<?php
    $messageOnBar = get_field('message_to_show', 'options');
    $hideBar = get_field('hide_bar', 'options');
?>
<?php if(!$hideBar && $messageOnBar && $messageOnBar != ""){ ?>
    <div class="announcement-bar">
        <?= $messageOnBar; ?>
    </div>
<?php } ?>
<header class="l-header" data-state="closed">
    <div class="l-header__contain contain">
        <a class="l-header__brand" href="<?php echo esc_url(home_url('/')); ?>">
            <?php
            $path = get_template_directory() . '/dist/images/the-circle-logo.svg';
            $file = file_get_contents($path);

            // remove xml header
            $file = str_replace(
                '<?xml version="1.0" encoding="UTF-8"?>',
                '',
                $file
            );

            // add class and attributes for accessibility
            echo str_replace(
                '<svg',
                '<svg class="l-header__logo" role="img" aria-label="Dundee Volunteer and Voluntary Action"',
                $file
            );
            ?>
        </a>

        <nav class="l-header__nav l-nav">

            <button
                    id="nav-toggle"
                    type="button"
                    class="l-nav__toggle b-navToggle"
                    data-state="closed"
                    aria-controls="primary-nav"
                    aria-expanded="false"
                    aria-label="Open primary navigation">
                    <div class="b-navToggle__burger">
                        <span class="b-navToggle__bar"></span>
                        <span class="b-navToggle__bar"></span>
                        <span class="b-navToggle__bar"></span>
                    </div>
            </button>

            <div class="l-nav__wrap" id="primary-nav" data-state="closed">
                <?php if (has_nav_menu('main_menu')) {
                    wp_nav_menu([
                        'theme_location'    => 'main_menu',
                        'menu_container'    => 'ul',
                        'menu_class'        => 'l-nav__menu',
                        'items_wrap'        => '<ul id="%1$s" class="%2$s" role="list">%3$s</ul>',
                    ]);
                } ?>
            </div>

            <?php
            $bookNowLink = get_field('book_now_link', 'option');
            ?>

            <a href="<?= $bookNowLink['url']; ?>" class="book-now u-case fw-700"><span class="text">Book now</span></a>

            <div class="cart-holder">
                <a href="<?= wc_get_cart_url(); ?>" class="cart u-case fw-700"><span class="fas fa-shopping-cart"></span></a>
                <?php
                global $woocommerce;
                $cartCount = $woocommerce->cart->cart_contents_count;
                if ($cartCount > 0) {
                    echo '<span class="cart-total-badge">'.$cartCount.'</span>';
                }
                ?>
            </div>


        </nav>
    </div>
</header>
