<?php
$title = get_sub_field('title');
$type = get_sub_field('type');
$logos = get_sub_field('logos');

if($logos) { ?>
    <section class="custom-flexible-section logo-slider-section">
        <div class="contain">
            <?php if($title) { ?><h2 class="text-center fw-500"><?= $title; ?></h2><?php } ?>
            <div class="logos <?= $type; ?>">
                <div class="swiper-container">
                    <div class="swiper-wrapper">
                        <?php foreach($logos as $logo) {
                            $imageDetails = wp_get_attachment_image_src($logo['image']['id'], 'logo-image');
                            $image = '<img src=" ' . $imageDetails[0] . '" alt="'. $logo['image']['alt'] .'">';
                            ?>
                            <div class="swiper-slide">
                                <div class="logo-item">
                                    <?php if($logo['link']){ ?><a href="<?= $logo['link']['url']; ?>" target="<?= $logo['link']['target']; ?>"><?php } ?>
                                        <?= $image; ?>
                                    <?php if($logo['link']){ ?></a><?php } ?>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php } ?>
