<?php
namespace Blue2\Scruffy;

use Blue2\Scruffy\Controllers\EventController;
use Blue2\Scruffy\Controllers\ProductController;
use Blue2\Scruffy\Controllers\XeroController;

class Site extends \Blue2\Common\Site
{
    public function __construct()
    {
        parent::__construct();


        add_theme_support('post-thumbnails');
        add_theme_support('woocommerce');
        add_action('after_setup_theme', [$this, 'registerMenus']);
        add_filter('excerpt_more', [$this, 'tidyExcerpt']);
        add_filter( 'woocommerce_checkout_fields' , [$this, 'wpb_custom_additional_info'] );

        $this->registerShortCodes();
        $this->registerFilters();
        $this->registerActions();
        $this->setupControllers();
    }

    // Change placeholder text in Additional Notes
    public function wpb_custom_additional_info( $fields ) {
        $fields['order']['order_comments']['placeholder'] = 'Here is where you can add additional notes regarding your order e.g., dietary requirements for bookings or a delivery note for products';
        return $fields;
    }

    public function registerMenus()
    {
        register_nav_menus([
            'main_menu' => 'Main Menu',
            'footer_menu' => 'Footer Menu',
            'footer_the_circle' => 'Footer "The Circle" Menu',
            'footer_our_spaces' => 'Footer "Our Spaces" Menu',
            'footer_contact_us' => 'Footer "Contact Us" Menu',
        ]);
    }

    public function tidyExcerpt()
    {
        return '...';
    }

    private function registerShortCodes()
    {
        add_shortcode( 'iframeMap', [$this, 'iframeMapShortcode'] );
    }

    private function registerFilters(){
        add_filter('excerpt_length', [$this, 'my_excerpt_length']);
        add_filter('acf/fields/google_map/api', [$this, 'myAcfGoogleMapApi']);
        add_filter('wp_enqueue_scripts', [$this, 'enqueueScripts']);
        add_filter( 'woocommerce_email_recipient_new_order', [$this, 'custom_email_recipient_new_order'], 10, 2);
        add_filter( 'woocommerce_checkout_order_processed', [$this, 'filter_woocommerce_order_get_items'], 10, 2 );
    }

    private function registerActions() {
        add_action('init', [$this, 'registerPostTypes']);
        add_action('wp_enqueue_scripts', [$this, 'dequeueStyles'], 100);
        add_action('wp_print_scripts', [$this, 'dequeueScripts'], 100 );
        add_action('login_enqueue_scripts', [$this, 'customLoginStylesheet']);
        add_action('init', [$this, 'customImageSizes']);
        add_action( 'woocommerce_email', [$this, 'unhook_those_pesky_emails'] );
        
    }

    private function setupControllers(){
        new ProductController();
        new EventController();
        new XeroController();
    }

    public function registerPostTypes()
    {
        Post\Event::registerPostType();
    }

    public function customImageSizes()
    {
        add_image_size('2-wide', 761, 381, true);
        add_image_size('3-wide', 490, 245, true);
        add_image_size('4-wide', 355, 177, true);
        add_image_size('flexible-space-blocks', 355, 266, true);
        add_image_size('service-image', 628, 628, true);
        add_image_size('product-archive-image', 656, 491, true);
        add_image_size('logo-image', 177, 0, false);
        add_image_size('flexible-split-25', 357, 0, false);
        add_image_size('flexible-split-40', 628, 0, false);
        add_image_size('flexible-split-50', 763, 0, false);
        add_image_size('flexible-split-60', 898, 0, false);
        add_image_size('flexible-split-75', 1170, 0, false);
        add_image_size('flexible-title-image', 1576, 0, false);
        add_image_size('blog-image', 490, 245, true);


    }

        public static function getDefaultImage() {
        $path = get_template_directory() . '/dist/images/the-circle-logo-white.svg';
        $file = file_get_contents($path);
        // remove xml header
        $file = str_replace(
            '<?xml version="1.0" encoding="UTF-8"?>',
            '',
            $file
        );
        // add class and attributes for accessibility
        return str_replace(
            '<svg',
            '<svg class="default-logo" role="img" aria-label="The Circle"',
            $file
        );
    }

    function my_excerpt_length($length){
        return 26;
    }

    public function myAcfGoogleMapApi($api)
    {
        $api['key'] = 'AIzaSyA8c9Yr11Q8Iw-XH8lOiLyMKT7tEqET7C0';
        return $api;
    }

    public function enqueueScripts()
    {
        if (is_product()) {
            wp_enqueue_script('google-maps', '//maps.googleapis.com/maps/api/js?key=AIzaSyA8c9Yr11Q8Iw-XH8lOiLyMKT7tEqET7C0', ['jquery'], null, true);
        }
    }

    function dequeueStyles(){
        wp_dequeue_style('wp-block-library');
        wp_dequeue_style('wp-block-library-theme');
        wp_dequeue_style('wc-block-style');
    }

    function dequeueScripts(){
        wp_dequeue_script('jquery-migrate');
    }

    public function customLoginStylesheet()
    {
        wp_enqueue_style('custom-login', get_stylesheet_directory_uri() . '/assets/styles/login.css');
    }

    function iframeMapShortcode( $atts ) {
        $a = shortcode_atts([
            'url' => '',
        ], $atts );
        return "
            <div class='custom-iframe-map-wrapper'>
            <iframe src='" . $atts['url'] . "' frameborder='0' allow='accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture' allowfullscreen loading='lazy'></iframe>
            </div>
        ";
    }

    

    public function unhook_those_pesky_emails( $email_class ) {

        if ( is_admin() && ! wp_doing_ajax() ) {

            // New order emails
            remove_action( 'woocommerce_order_status_pending_to_processing_notification', array( $email_class->emails['WC_Email_New_Order'], 'trigger' ) );
            remove_action( 'woocommerce_order_status_pending_to_completed_notification', array( $email_class->emails['WC_Email_New_Order'], 'trigger' ) );
            remove_action( 'woocommerce_order_status_pending_to_on-hold_notification', array( $email_class->emails['WC_Email_New_Order'], 'trigger' ) );
            remove_action( 'woocommerce_order_status_failed_to_processing_notification', array( $email_class->emails['WC_Email_New_Order'], 'trigger' ) );
            remove_action( 'woocommerce_order_status_failed_to_completed_notification', array( $email_class->emails['WC_Email_New_Order'], 'trigger' ) );
            remove_action( 'woocommerce_order_status_failed_to_on-hold_notification', array( $email_class->emails['WC_Email_New_Order'], 'trigger' ) );

            // Processing order emails
            remove_action( 'woocommerce_order_status_pending_to_processing_notification', array( $email_class->emails['WC_Email_Customer_Processing_Order'], 'trigger' ) );
            remove_action( 'woocommerce_order_status_pending_to_on-hold_notification', array( $email_class->emails['WC_Email_Customer_Processing_Order'], 'trigger' ) );

            // Completed order emails
            remove_action( 'woocommerce_order_status_completed_notification', array( $email_class->emails['WC_Email_Customer_Completed_Order'], 'trigger' ) );

        }
    }

    
    function custom_email_recipient_new_order( $recipient, $order ) {
        // Not in backend when using $order (avoiding an error)
        if( ! is_a($order, 'WC_Order') ) return $recipient;

        // Define the email recipients / categories pairs in the array
        $emailsToLocation = "";
        if(have_rows('recipients_categories', 'options')){
            while(have_rows('recipients_categories', 'options')){
                the_row();
                $location = get_sub_field('location');
                foreach($order->get_items() as $item){
                    foreach($location as $recipientLocation){
                        $emailToAdd = get_sub_field('email_address');
                        if(has_term( $recipientLocation, 'location', $item->get_product_id() ) && strpos($emailsToLocation, $emailToAdd) === false){
                            $emailsToLocation .= ($emailsToLocation !== "" ? ", ": "").$emailToAdd;
                        }
                    }                      
                    
                }
            }
        }
        return $emailsToLocation;
    }

    function filter_woocommerce_order_get_items($order_id){
        $order = wc_get_order( $order_id );
        foreach ($order->get_items() as $item){
            $locations = get_the_terms($item->get_product_id(), 'location');
            $locations = $locations && is_array($locations) && !is_empty($locations) ? self::getLocationsFromWpTermArray($locations) : "";
            if($locations != "" && strpos($item->get_name(), $locations) === false){
                $item->set_name( $item->get_name() . ' - '. $locations );
                $item->save();
            }
        }
        $order->save();
    }
    
    public static function getLocationsFromWpTermArray($locations){
        $locationsString = "";
        foreach($locations as $locationTerm){
            if($locationsString !== ""){
                $locationsString .= ", ";
            }
            $locationsString .= $locationTerm->name;
        }
        return $locationsString;
    }

}
