const LIGHTBOX =
{
    instance : null,
    images : [],
    onClick() {
        const src = $(this).find('img')
            .prop('src');

        const index = LIGHTBOX.images
            .indexOf(src);

        if (index === -1) {
            return;
        }

        LIGHTBOX.instance.addClass('shown');
        LIGHTBOX.setActive(index);
    },
    onHide() {
        LIGHTBOX.instance.removeClass('shown')
            .find('.lightbox-item')
            .removeClass('active');
    },
    onPrev() {
        const index = LIGHTBOX.getActiveIndex();

        LIGHTBOX.setActive(index - 1);
    },
    onNext() {
        const index = LIGHTBOX.getActiveIndex();

        LIGHTBOX.setActive(index + 1);
    },
    setActive(index) {
        const tmpIndex = index < 0
            ? LIGHTBOX.images.length + index
            : index % LIGHTBOX.images.length;

        LIGHTBOX.instance.find('.lightbox-item')
            .removeClass('active')
            .eq(tmpIndex)
            .addClass('active');
    },
    getActiveIndex() {
        return LIGHTBOX.instance.find('.lightbox-item')
            .filter('.active')
            .index() - 1;
    }
};

export default LIGHTBOX;
