<?php
$color = get_sub_field('colour');
$title = get_sub_field('title');
$desc = get_sub_field('description');

$primaryCol = $desc ? 'col-lg-6' : 'col-lg-12 d-flex justify-content-center';
$secondaryCol = $desc ? 'col-lg-6' : 'col-lg-12 d-flex justify-content-center';

?>
<section class="custom-flexible-section very-connect-section <?= 'color-' . $color; ?>">
    <div class="contain">
        <div class="inner">
            <div class="row">
                <div class="<?= $primaryCol; ?> content-col">
                    <?php if($title) { ?><h2 class="fw-500"><?= $title; ?></h2><?php } ?>
                    <?php if($desc) { ?><div class="description"><?= $desc; ?></div><?php } ?>
                </div>
                <div class="<?= $secondaryCol; ?> form-col custom-content">
                    <form action="https://academy.thecirclecic.org.uk/api/v1/auth/local" method="POST" target="_blank">
                        <div class="form-group">
                            <input type="email" name="email" class="form-control" placeholder="Email" />
                        </div>
                        <div class="form-group">
                            <input type="password" name="password" class="form-control" placeholder="Password" />
                        </div>

                        <button type="submit" class="u-case fw-700">Submit</button>
                        <div style="margin-top: 20px;"><a href="https://academy.thecirclecic.org.uk/passwordrecovery/email">Forgot your password?</a></div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
