<?php
namespace Blue2\Scruffy\Controllers;

class EventController
{
    public function __construct()
    {
        $this->registerActions();
        $this->registerFilters();
    }

    private function registerActions()
    {
        add_action('pre_get_posts', [$this, 'orderEvents']);
        add_action('init', [$this, 'registerTaxonomies']);
    }

    private function registerFilters()
    {

    }

    public function orderEvents($query) {
        if (!is_admin() && $query->is_main_query() && is_post_type_archive('event')) {
            $query->set('posts_per_page', 6);
            $query->set('orderby', 'meta_value');
            $query->set('meta_key', 'event_date');
            $query->set('order', 'ASC');
        }
    }

    public function registerTaxonomies()
    {
        $eventCategory = new \Blue2\Common\Taxonomy("event-category", "Event Category", "Event Categories", "event", [], $args = [
            'show_ui' => true,
            'query_var' => true,
            'show_admin_column' => true,
        ]);
    }
}
