<?php
$categories = get_terms('event-category');
$queriedObject = get_queried_object();
?>

<div class="custom-posts-archive">
    <div class="contain">
        <h1><?= is_tax() ? 'Events - ' . get_queried_object()->name : 'Events' ?></h1>
        <?php if($categories) { ?>
            <ul class="blog-categories">
                <li class="<?= is_post_type_archive('event') ? 'active' : 'inactive'; ?> fw-700"><a href="/events/">All</a></li>
                <?php foreach($categories as $cat) {
                    $activeClass = $cat->slug == (is_tax('event-category') && $queriedObject->slug) ? 'active' : 'in-active'; ?>
                    <li class="<?= $activeClass; ?> fw-700"><a href="<?= get_category_link($cat->term_id); ?>"><?= $cat->name; ?></a></li>
                <?php } ?>
            </ul>
        <?php } ?>
        <div class="row row-eq-height">
            <?php Blue2\Scruffy\Utils::archiveLoop(); ?>
        </div>
        <div class="custom-pagination">
            <?php
            the_posts_pagination([
                'mid_size' => 1,
                'prev_text' => __('<', 'textdomain'),
                'next_text' => __('>', 'textdomain'),
                'before_page_number' => '<span class="meta-nav screen-reader-text">' . __('', '') . ' </span>',
            ]); ?>
        </div>
    </div>
</div>




