import { fontawesome, throttle } from './utils';
import Swiper from 'swiper';

const nav = {
    breakpoint: 992,
    isOpen: false,
    lastWidth: window.innerWidth,
    el: {
        scrollEl:   document.documentElement,
        toggle:     document.querySelector('.l-nav__toggle'),
        nav:        document.querySelector('.l-nav'),
        header:     document.querySelector('.l-header'),
    },
    init: () => {
        nav.el.toggle.addEventListener('click', nav.toggle);
        window.addEventListener('resize', nav.resize);
    },

    toggle: () => {
        const isOpen = nav.el.toggle.getAttribute('data-state') === 'open';
        if (isOpen) {
            nav.close();
        } else {
            nav.open();
        }
    },

    open: () => {
        nav.el.scrollEl.style.overflow = 'hidden';
        nav.el.header.setAttribute('data-state', 'open');
        nav.el.nav.setAttribute('data-state', 'open');
        nav.el.toggle.setAttribute('data-state', 'open');
        nav.el.toggle.setAttribute('aria-expanded', 'true');
        nav.el.toggle.setAttribute('aria-label', 'Close primary navigation');
        nav.el.nav.focus();
        nav.isOpen = true;
    },

    close: () => {
        nav.el.scrollEl.style.overflow = null;
        nav.el.header.setAttribute('data-state', 'closed');
        nav.el.nav.setAttribute('data-state', 'closed');
        nav.el.toggle.setAttribute('data-state', 'closed');
        nav.el.toggle.setAttribute('aria-expanded', 'false');
        nav.el.toggle.setAttribute('aria-label', 'Open primary navigation');
        nav.el.toggle.focus();
        nav.isOpen = false;
    },

    resize: throttle(() => {
        const currentWidth = window.innerWidth;
        // going from below breakpoint to above
        if (nav.lastWidth <= nav.breakpoint && currentWidth > nav.breakpoint) {
            // if nav open, close it
            if (nav.isOpen) {
                nav.close();
            }
        }
        nav.lastWidth = currentWidth;
    }, 1000)
};

const common = () => {
    nav.init();
    fontawesome();


    function formUpdate(){
        var checker = false;
        var checkCount = 0;
        checker = setInterval(function(){
            checkCount++;
            if($('.timeslot-lists.ts-grid-container li').length > 0 || checkCount > 15){
                clearInterval(checker);
                checkCount = 0;


        // Select the target node.
                var target = $(document).find('#show_time_slot')[0];
                // Create an observer instance.
                var observer = new MutationObserver(function(mutations) {
                    $('.timeslot-lists.ts-grid-container li').each(function(i,j){
                    
                        var currTxt = $(j).find('a').text();
                        
                        if(currTxt == '09:00 - 13:00'){
                            //half day morning
                            $(j).find('a').text('Half day (' + currTxt + ')');
                            $(j).appendTo('.timeslot-lists.ts-grid-container');
                        }
                        if(currTxt == '13:00 - 17:00'){
                            //half day afternoon
                            $(j).find('a').text('Half day (' + currTxt + ')');
                            $(j).appendTo('.timeslot-lists.ts-grid-container');
                        }
                        if(currTxt == '09:00 - 17:00'){
                            //full day
                            $(j).find('a').text('Full day (' + currTxt + ')');
                            $(j).appendTo('.timeslot-lists.ts-grid-container');
                        }
                    });   
                });

                // Pass in the target node, as well as the observer options.
                observer.observe(target, {
                    attributes:    true,
                    childList:     true,
                    characterData: true
                });

                $('.timeslot-lists.ts-grid-container li').each(function(i,j){
                    
                    var currTxt = $(j).find('a').text();
                    
                    if(currTxt == '09:00 - 13:00'){
                        //half day morning
                        $(j).find('a').text('Half day (' + currTxt + ')');
                        $(j).appendTo('.timeslot-lists.ts-grid-container');
                    }
                    if(currTxt == '13:00 - 17:00'){
                        //half day afternoon
                        $(j).find('a').text('Half day (' + currTxt + ')');
                        $(j).appendTo('.timeslot-lists.ts-grid-container');
                    }
                    if(currTxt == '09:00 - 17:00'){
                        //full day
                        $(j).find('a').text('Full day (' + currTxt + ')');
                        $(j).appendTo('.timeslot-lists.ts-grid-container');
                    }
                });  

                
            }
        }, 200);
    }

    if ($('#hero-video').hasClass('autoplay') && window.innerWidth > 767) {
        $('#hero-video')[0].play();
        $('#hero-video').attr('data-status','play');
    }
    
    
    if($('#bkap-booking-form').length > 0){
        formUpdate();


        $(document).on('click', '#inline_calendar', function(){
            formUpdate();
        });
        
    }

    $('#video-toggle').click(function() {
        const video = $('#hero-video');
        const status = video.attr('data-status');
        if (status === 'paused') {
            video[0].play();
            video.attr('data-status', 'play');
        } else {
            video[0].pause();
            video.attr('data-status', 'paused');
        }
        const icon = $('.action-toggle').find('svg');
        const iconFaIcon = icon.attr('data-icon');
        const actionText = $('.action .text');
        iconFaIcon === 'play' ? icon.attr('data-icon', 'pause') : icon.attr('data-icon', 'play');
        actionText.text() === 'Play video' ? actionText.text('Pause video') : actionText.text('Play video');
    });

    if ($('.logo-slider-section').length) {
        const logoSlider = new Swiper('.logo-slider-section .swiper-container', {
            autoplay: {
                delay: 1000,
            },
            loop: true,
            lazy: true,
            loopAdditionalSlides: 6,
            breakpoints: {
                0: {
                    slidesPerView: 2,
                    spaceBetween: 50
                },
                450: {
                    slidesPerView: 3,
                    spaceBetween: 50
                },
                768: {
                    slidesPerView: 4,
                    spaceBetween: 50
                },
                992: {
                    slidesPerView: 5,
                    spaceBetween: 50
                },
                1200: {
                    spaceBetween: 50,
                    slidesPerView: 6,
                }
            },
        });

        $('.logo-slider-section .swiper-container').hover(function() {
            logoSlider.autoplay.stop();
        }, function() {
            logoSlider.autoplay.start();
        });
    }

    if ($('#teamModal').length) {
        $('#teamModal').on('show.bs.modal', function(event) {
            const teamMember = $(event.relatedTarget);
            const name = teamMember.data('name');
            const title = teamMember.data('title');
            const desc = teamMember.data('description');
            const modal = $(this);
            modal.find('.modal-title').text(name);
            modal.find('.title').text(title);
            modal.find('.description').html(desc);
        });
    }
};

export default common;
