const singleProduct = () => {
    if ($('#map').length) {
        const google = window.google;
        const mapLng = $('#map')
            .data('lng');
        const mapLat = $('#map')
            .data('lat');
        const mapZoom = $('#map')
            .data('zoom');
        const mapCenter = { lat: mapLat, lng: mapLng };
        const map = new google.maps.Map(document.getElementById('map'), {
            zoom: mapZoom,
            center: mapCenter,
            scrollWheel: false,
            streetViewControl: false,
        });
        new google.maps.Marker({
            position: mapCenter,
            map,
        });
    }

    $('.custom-buttons a[href*=\\#]').on('click', function(event) {
        event.preventDefault();
        $('html,body').animate({ scrollTop:$(this.hash).offset().top - 150 }, 500);
    });
};

export default singleProduct;
