<?php
$defaultImage = \Blue2\Scruffy\Site::getDefaultImage();
if(get_post_thumbnail_id()){
    $imageDetails = wp_get_attachment_image_src(get_post_thumbnail_id(), "flexible-space-blocks");
    $image = '<img src=" ' . $imageDetails[0] . '" alt="'. get_the_title() .'">';
    $imageClass = 'featured-image';
} else {
    $image = $defaultImage;
    $imageClass = 'default-image';
}

$eventbriteLink = get_field('eventbrite_link');
$link = $eventbriteLink  ?: get_the_permalink();
$linkText = $eventbriteLink ? 'Register Now' : 'View Details';
$linkTarget = $eventbriteLink ? '_blank' : '_self';

$timeOutput = "";
$eventDate = get_field('event_date');
$eventStartTime = get_field('event_start_time');
$eventEndTime = get_field('event_end_time');

if($eventStartTime){
    $timeOutput = $eventStartTime;
}
if($eventEndTime) {
    $timeOutput .= ' - ' . $eventEndTime;
}
?>
<div class="event-col col-md-6 event-col">
    <div class="event-inner">
        <div class="image-wrapper <?= $imageClass; ?>">
            <?= $image; ?>
        </div>
        <div class="content-wrapper">
            <h3 class="fw-500"><a href="<?= get_the_permalink(); ?>"><?php the_title() ?></a></h3>
            <div class="description"><?= get_the_excerpt(); ?></div>
            <div class="event-info">
                <div class="start-date"><span class="fas fa-calendar"></span><?= $eventDate; ?></div>
                <?php if($timeOutput) { ?><div class="time"><span class="fas fa-clock"></span><?= $timeOutput; ?></div><?php } ?>
            </div>
            <div class="cta">
                <a href="<?= $link; ?>" target="<?= $linkTarget; ?>" class="u-case fw-700"><?= $linkText; ?></a>
            </div>
        </div>
    </div>
</div>
