<?php
$contactEmail = get_field('contact_email_address', 'option');
$contactPhone = get_field('contact_phone_number', 'option');
$socials = get_field('social_media_channels', 'option');
$address = get_field('company_address', 'option');
$copyrightText = get_field('copyright_text', 'option');
$creditMessage = get_field('credit_message','option');
$creditLink = get_field('credit_link','option');
?>

<footer class="site-footer">
    <div class="contain">
        <div class="top-row row">
            <div class="col-lg-8">
                <div class="row">
                    <div class="col-lg-3 social-col">
                        <?php
                        $path = get_template_directory() . '/dist/images/the-circle-logo-white.svg';
                        $file = file_get_contents($path);
                        $file = str_replace(
                            '<?xml version="1.0" encoding="UTF-8"?>',
                            '',
                            $file
                        );
                        echo str_replace(
                            '<svg',
                            '<svg class="footer-logo" role="img" aria-label="The Circle"',
                            $file
                        );
                        ?>
                        <?php if($socials) { ?>
                            <ul>
                                <?php foreach($socials as $social) { ?>
                                    <li><a href="<?= $social['full_url']; ?>" target="_blank"><span class="fab <?= $social['platform']; ?>" id="theme-svg"></span></a></li>
                                <?php } ?>
                            </ul>
                        <?php } ?>
                    </div>
                    <div class="col-sm-4 col-lg-3 menu-col">
                        <h3 class="fw-700">The Circle</h3>
                        <?php
                        if (has_nav_menu( 'footer_the_circle' )) {
                            wp_nav_menu(['theme_location' => 'footer_the_circle', 'menu_class' => '']);
                        }
                        ?>
                    </div>
                    <div class="col-sm-4 col-lg-3 menu-col">
                        <h3 class="fw-700">Our Spaces</h3>
                        <?php
                        if (has_nav_menu( 'footer_our_spaces' )) {
                            wp_nav_menu(['theme_location' => 'footer_our_spaces', 'menu_class' => '']);
                        }
                        ?>
                    </div>
                    <div class="col-sm-4 col-lg-3 menu-col">
                        <h3 class="fw-700">Contact Us</h3>
                        <?php
                        if (has_nav_menu( 'footer_contact_us' )) {
                            wp_nav_menu(['theme_location' => 'footer_contact_us', 'menu_class' => '']);
                        }
                        ?>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 subscribe-col">
                <label for="mce-EMAIL" class="fw-700">Subscribe to our newsletter</label>
                <?php the_field('mailchimp_script', 'option'); ?>
            </div>
        </div>

        <div class="bottom-row row">
            <div class="col-lg-8 copyright-and-menu-col">
                <p>&copy; <?= date("Y") . ' ' . $copyrightText ?></p>
                <?php
                if (has_nav_menu( 'footer_menu' )) {
                    wp_nav_menu(['theme_location' => 'footer_menu', 'menu_class' => 'documentation_menu']);
                }
                ?>
            </div>
            <div class="col-lg-4 website-by-col">
                <?php 
                    if($creditMessage){
                        echo '<p class="credit-message">'.$creditMessage;
                        if($creditLink){
                            echo ' <a href="'.$creditLink['url'].'" target="'.$creditLink['target'].'">'.$creditLink['title'].'</a>';
                        }
                        echo '</p>';
                    }
                ?>
                <p>Website by <?= do_shortcode( '[blue2_logo type="light"]' ); ?></p>
            </div>
        </div>

    </div>
</footer>
