<?php
$title = get_sub_field('title');
$desc = get_sub_field('description');

$videoType = get_sub_field('video_type');
$width = get_sub_field('width');
$widthClass = $width == 'full' ? 'full-width' : 'reduced-width';

$embed = get_sub_field('embed_video');
$customVideo = get_sub_field('custom_video');

?>
<section class="custom-flexible-section video-section">
    <div class="contain">

        <?php if($title || $desc) { ?>
            <div class="top-section">
                <?php if($title) { ?><h2 class="fw-500"><?= $title; ?></h2><?php } ?>
                <?php if($desc) { ?><div class="description"><?= $desc; ?></div><?php } ?>
            </div>
        <?php } ?>

        <div class="video-container <?= $widthClass; ?>">
            <div class="video-wrapper">
                <?php
                if($videoType == 'embed-video') {
                    preg_match('/src="(.+?)"/', $embed, $matches);
                    $src = $matches[1];
                    $params = [
                        'controls'  => 1,
                        'hd'        => 1,
                        'autohide'  => 1,
                        'rel' => 0
                    ];
                    $new_src = add_query_arg($params, $src);
                    $embed = str_replace($src, $new_src, $embed);
                    $attributes = 'frameborder="0" loading="lazy"';
                    $embed = str_replace('></iframe>', ' ' . $attributes . '></iframe>', $embed);

                    echo $embed;
                }
                else { ?>
                    <video controls>
                        <source src="<?= $customVideo['url']; ?>" type="video/mp4">
                    </video>
                <?php } ?>
            </div>
        </div>
    </div>
</section>
