<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
    return;
}

$building = get_the_terms(get_the_id(), 'building');
$location = get_the_terms(get_the_id(), 'location');
$defaultImage = \Blue2\Scruffy\Site::getDefaultImage();
$features = get_field('attributes');

if(get_post_thumbnail_id()){
    $imageDetails = wp_get_attachment_image_src(get_post_thumbnail_id(), "flexible-space-blocks");
    $image = '<img src=" ' . $imageDetails[0] . '" alt="'. get_the_title() .'">';
    $imageClass = 'featured-image';
} else {
    $image = $defaultImage;
    $imageClass = 'default-image';
}
$stockStatus = get_post_meta( get_the_id(), '_stock_status', true );
$stockStatusText = $stockStatus == 'instock' ? 'Available' : 'Unavailable';
$stockStatusClass = $stockStatus == 'instock' ? 'in-stock' : 'no-stock';
?>
<div <?php wc_product_class( 'col-12', $product ); ?>>
    <div class="custom-space-item <?= $stockStatusClass; ?>">
        <div class="row no-gutters row-eq-height">
            <div class="col-lg-5">
                <div class="image-wrapper <?= $imageClass; ?>">
                    <div class="stock-status"><?= $stockStatusText; ?></div>
                    <?= $image; ?>
                </div>
            </div>
            <div class="col-lg-7">
                <div class="content-wrapper">
                    <?php if($building || $location) { ?>
                        <div class="space-attributes">
                            <ul>
                                <?php if($building) { ?><li><?= $building[0]->name; ?></li><?php } ?>
                                <?php if($location) { ?><li><?= $location[0]->name; ?></li><?php } ?>
                            </ul>
                        </div>
                    <?php } ?>
                    <h2 class="fw-500"><?php the_title(); ?></h2>
                    <?php the_excerpt(); ?>

                    <?php if($features) { ?>
                        <div class="features">
                            <ul>
                                <?php foreach($features as $feature) { ?>
                                    <li><span class="far <?= $feature['icon']; ?>"></span> <?= $feature['title']; ?></li>
                                <?php } ?>
                            </ul>
                        </div>
                    <?php } ?>

                    <a href="<?php the_permalink(); ?>" class="u-case fw-700 view-details-button">View Details</a>

                </div>
            </div>
        </div>
    </div>
</div>
