<?php
namespace Blue2\Scruffy\Controllers;

class ProductController
{
    public function __construct()
    {
        $this->registerActions();
        $this->registerFilters();
    }

    private function registerActions()
    {
        add_action('init', [$this, 'woocommerceHookAdjustments']);
        add_action('init', [$this, 'registerTaxonomies']);
        add_action('pre_get_posts', [$this, 'filterSpaces']);
    }

    private function registerFilters()
    {
    }

    public function registerTaxonomies()
    {
        $location = new \Blue2\Common\Taxonomy("location", "Location", "Locations", "product", [], $args = [
            'show_ui' => true,
            'query_var' => true,
            'show_admin_column' => true,
        ]);

        $building = new \Blue2\Common\Taxonomy("building", "Building", "Buildings", "product", [], $args = [
            'show_ui' => true,
            'query_var' => true,
            'show_admin_column' => true,
        ]);

        $capacity = new \Blue2\Common\Taxonomy("capacity", "Capacity", "Room Capacity", "product", [], $args = [
            'show_ui' => true,
            'query_var' => true,
            'show_admin_column' => true,
        ]);
    }

    public function woocommerceHookAdjustments() {
        remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);
        remove_action('woocommerce_before_shop_loop', 'woocommerce_result_count', 20);
        remove_action('woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30);
    }

    public function filterSpaces($query) {
        if ( !is_admin() && $query->is_main_query() && is_tax('product_cat')) {
            $taxQuery = ['relation' => 'AND'];
            if (isset($_GET['space']) && $_GET['space'] !== '') {
                $space = $_GET['space'];
                $taxQuery[] = [
                    'taxonomy' => 'product_cat',
                    'terms' => $space,
                    'field' => 'slug',
                    'operator' => 'IN'
                ];
            }

            if (isset($_GET['location']) && $_GET['location'] !== '') {
                $location = $_GET['location'];
                $taxQuery[] = [
                    'taxonomy' => 'location',
                    'terms' => $location,
                    'field' => 'slug',
                    'operator' => 'IN'
                ];
            }

            if (isset($_GET['capacity']) && $_GET['capacity'] !== '') {
                $capacity = $_GET['capacity'];
                $taxQuery[] = [
                    'taxonomy' => 'capacity',
                    'terms' => $capacity,
                    'field' => 'slug',
                    'operator' => 'IN'
                ];
            }

            if(count($taxQuery) > 1) {
                $query->set('meta_key', '_stock_status');
                $query->set('meta_value', 'instock');
            }
            $query->set('tax_query', $taxQuery);
        }
    }
}
