<?php
/**
 * AssetApi
 * PHP version 5
 *
 * @category Class
 * @package  XeroAPI\XeroPHP Asset
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Xero Assets API
 *
 * The Assets API exposes fixed asset related functions of the Xero Accounting application and can be used for a variety of purposes such as creating assets, retrieving asset valuations etc.
 *
 * OpenAPI spec version: 2.15.0
 * Contact: api@xero.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 4.3.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace XeroAPI\XeroPHP\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use XeroAPI\XeroPHP\ApiException;
use XeroAPI\XeroPHP\Configuration;
use XeroAPI\XeroPHP\HeaderSelector;
use XeroAPI\XeroPHP\AssetObjectSerializer;

/**
 * AssetApi Class Doc Comment
 *
 * @category Class
 * @package  XeroAPI\XeroPHP
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class AssetApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createAsset
     * adds a fixed asset
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\Asset\Asset $asset Fixed asset you are creating (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\Asset\Asset
     */
    public function createAsset($xero_tenant_id, $asset)
    {
        list($response) = $this->createAssetWithHttpInfo($xero_tenant_id, $asset);
        return $response;
    }
    /**
     * Operation createAssetWithHttpInfo
     * adds a fixed asset
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\Asset\Asset $asset Fixed asset you are creating (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\Asset\Asset, HTTP status code, HTTP response headers (array of strings)
     */
    public function createAssetWithHttpInfo($xero_tenant_id, $asset)
    {
        $request = $this->createAssetRequest($xero_tenant_id, $asset);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\Asset\Asset' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        AssetObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\Asset\Asset', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\Asset\Asset';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                AssetObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = AssetObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\Asset\Asset',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createAssetAsync
     * adds a fixed asset
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\Asset\Asset $asset Fixed asset you are creating (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createAssetAsync($xero_tenant_id, $asset)
    {
        return $this->createAssetAsyncWithHttpInfo($xero_tenant_id, $asset)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createAssetAsyncWithHttpInfo
     * adds a fixed asset
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\Asset\Asset $asset Fixed asset you are creating (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createAssetAsyncWithHttpInfo($xero_tenant_id, $asset)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\Asset\Asset';
        $request = $this->createAssetRequest($xero_tenant_id, $asset);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        AssetObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createAsset'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\Asset\Asset $asset Fixed asset you are creating (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createAssetRequest($xero_tenant_id, $asset)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createAsset'
            );
        }
        // verify the required parameter 'asset' is set
        if ($asset === null || (is_array($asset) && count($asset) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $asset when calling createAsset'
            );
        }
        $resourcePath = '/Assets';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = AssetObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if (isset($asset)) {
            $_tempBody = $asset;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(AssetObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHostAsset() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createAssetType
     * adds a fixed asset type
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\Asset\AssetType $asset_type Asset type to add (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\Asset\AssetType
     */
    public function createAssetType($xero_tenant_id, $asset_type = null)
    {
        list($response) = $this->createAssetTypeWithHttpInfo($xero_tenant_id, $asset_type);
        return $response;
    }
    /**
     * Operation createAssetTypeWithHttpInfo
     * adds a fixed asset type
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\Asset\AssetType $asset_type Asset type to add (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\Asset\AssetType, HTTP status code, HTTP response headers (array of strings)
     */
    public function createAssetTypeWithHttpInfo($xero_tenant_id, $asset_type = null)
    {
        $request = $this->createAssetTypeRequest($xero_tenant_id, $asset_type);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\Asset\AssetType' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        AssetObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\Asset\AssetType', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\Asset\AssetType';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                AssetObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = AssetObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\Asset\AssetType',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createAssetTypeAsync
     * adds a fixed asset type
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\Asset\AssetType $asset_type Asset type to add (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createAssetTypeAsync($xero_tenant_id, $asset_type = null)
    {
        return $this->createAssetTypeAsyncWithHttpInfo($xero_tenant_id, $asset_type)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createAssetTypeAsyncWithHttpInfo
     * adds a fixed asset type
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\Asset\AssetType $asset_type Asset type to add (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createAssetTypeAsyncWithHttpInfo($xero_tenant_id, $asset_type = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\Asset\AssetType';
        $request = $this->createAssetTypeRequest($xero_tenant_id, $asset_type);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        AssetObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createAssetType'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\Asset\AssetType $asset_type Asset type to add (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createAssetTypeRequest($xero_tenant_id, $asset_type = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createAssetType'
            );
        }
        $resourcePath = '/AssetTypes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = AssetObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if (isset($asset_type)) {
            $_tempBody = $asset_type;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(AssetObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHostAsset() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAssetById
     * Retrieves fixed asset by id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $id fixed asset id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\Asset\Asset
     */
    public function getAssetById($xero_tenant_id, $id)
    {
        list($response) = $this->getAssetByIdWithHttpInfo($xero_tenant_id, $id);
        return $response;
    }
    /**
     * Operation getAssetByIdWithHttpInfo
     * Retrieves fixed asset by id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $id fixed asset id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\Asset\Asset, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAssetByIdWithHttpInfo($xero_tenant_id, $id)
    {
        $request = $this->getAssetByIdRequest($xero_tenant_id, $id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\Asset\Asset' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        AssetObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\Asset\Asset', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\Asset\Asset';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                AssetObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = AssetObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\Asset\Asset',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getAssetByIdAsync
     * Retrieves fixed asset by id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $id fixed asset id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAssetByIdAsync($xero_tenant_id, $id)
    {
        return $this->getAssetByIdAsyncWithHttpInfo($xero_tenant_id, $id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getAssetByIdAsyncWithHttpInfo
     * Retrieves fixed asset by id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $id fixed asset id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getAssetByIdAsyncWithHttpInfo($xero_tenant_id, $id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\Asset\Asset';
        $request = $this->getAssetByIdRequest($xero_tenant_id, $id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        AssetObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAssetById'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $id fixed asset id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getAssetByIdRequest($xero_tenant_id, $id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getAssetById'
            );
        }
        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling getAssetById'
            );
        }
        $resourcePath = '/Assets/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = AssetObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                AssetObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(AssetObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostAsset() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAssetSettings
     * searches fixed asset settings
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\Asset\Setting
     */
    public function getAssetSettings($xero_tenant_id)
    {
        list($response) = $this->getAssetSettingsWithHttpInfo($xero_tenant_id);
        return $response;
    }
    /**
     * Operation getAssetSettingsWithHttpInfo
     * searches fixed asset settings
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\Asset\Setting, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAssetSettingsWithHttpInfo($xero_tenant_id)
    {
        $request = $this->getAssetSettingsRequest($xero_tenant_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\Asset\Setting' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        AssetObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\Asset\Setting', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\Asset\Setting';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                AssetObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = AssetObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\Asset\Setting',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getAssetSettingsAsync
     * searches fixed asset settings
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAssetSettingsAsync($xero_tenant_id)
    {
        return $this->getAssetSettingsAsyncWithHttpInfo($xero_tenant_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getAssetSettingsAsyncWithHttpInfo
     * searches fixed asset settings
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getAssetSettingsAsyncWithHttpInfo($xero_tenant_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\Asset\Setting';
        $request = $this->getAssetSettingsRequest($xero_tenant_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        AssetObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAssetSettings'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getAssetSettingsRequest($xero_tenant_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getAssetSettings'
            );
        }
        $resourcePath = '/Settings';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = AssetObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(AssetObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostAsset() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAssetTypes
     * searches fixed asset types
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\Asset\AssetType[]
     */
    public function getAssetTypes($xero_tenant_id)
    {
        list($response) = $this->getAssetTypesWithHttpInfo($xero_tenant_id);
        return $response;
    }
    /**
     * Operation getAssetTypesWithHttpInfo
     * searches fixed asset types
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\Asset\AssetType[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getAssetTypesWithHttpInfo($xero_tenant_id)
    {
        $request = $this->getAssetTypesRequest($xero_tenant_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\Asset\AssetType[]' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        AssetObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\Asset\AssetType[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\Asset\AssetType[]';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                AssetObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = AssetObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\Asset\AssetType[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getAssetTypesAsync
     * searches fixed asset types
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAssetTypesAsync($xero_tenant_id)
    {
        return $this->getAssetTypesAsyncWithHttpInfo($xero_tenant_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getAssetTypesAsyncWithHttpInfo
     * searches fixed asset types
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getAssetTypesAsyncWithHttpInfo($xero_tenant_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\Asset\AssetType[]';
        $request = $this->getAssetTypesRequest($xero_tenant_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        AssetObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAssetTypes'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getAssetTypesRequest($xero_tenant_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getAssetTypes'
            );
        }
        $resourcePath = '/AssetTypes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = AssetObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(AssetObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostAsset() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAssets
     * searches fixed asset
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\Asset\AssetStatusQueryParam $status Required when retrieving a collection of assets. See Asset Status Codes (required)
     * @param  int $page Results are paged. This specifies which page of the results to return. The default page is 1. (optional)
     * @param  int $page_size The number of records returned per page. By default the number of records returned is 10. (optional)
     * @param  string $order_by Requests can be ordered by AssetType, AssetName, AssetNumber, PurchaseDate and PurchasePrice. If the asset status is DISPOSED it also allows DisposalDate and DisposalPrice. (optional)
     * @param  string $sort_direction ASC or DESC (optional)
     * @param  string $filter_by A string that can be used to filter the list to only return assets containing the text. Checks it against the AssetName, AssetNumber, Description and AssetTypeName fields. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\Asset\Assets
     */
    public function getAssets($xero_tenant_id, $status, $page = null, $page_size = null, $order_by = null, $sort_direction = null, $filter_by = null)
    {
        list($response) = $this->getAssetsWithHttpInfo($xero_tenant_id, $status, $page, $page_size, $order_by, $sort_direction, $filter_by);
        return $response;
    }
    /**
     * Operation getAssetsWithHttpInfo
     * searches fixed asset
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\Asset\AssetStatusQueryParam $status Required when retrieving a collection of assets. See Asset Status Codes (required)
     * @param  int $page Results are paged. This specifies which page of the results to return. The default page is 1. (optional)
     * @param  int $page_size The number of records returned per page. By default the number of records returned is 10. (optional)
     * @param  string $order_by Requests can be ordered by AssetType, AssetName, AssetNumber, PurchaseDate and PurchasePrice. If the asset status is DISPOSED it also allows DisposalDate and DisposalPrice. (optional)
     * @param  string $sort_direction ASC or DESC (optional)
     * @param  string $filter_by A string that can be used to filter the list to only return assets containing the text. Checks it against the AssetName, AssetNumber, Description and AssetTypeName fields. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\Asset\Assets, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAssetsWithHttpInfo($xero_tenant_id, $status, $page = null, $page_size = null, $order_by = null, $sort_direction = null, $filter_by = null)
    {
        $request = $this->getAssetsRequest($xero_tenant_id, $status, $page, $page_size, $order_by, $sort_direction, $filter_by);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\Asset\Assets' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        AssetObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\Asset\Assets', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\Asset\Assets';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                AssetObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = AssetObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\Asset\Assets',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getAssetsAsync
     * searches fixed asset
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\Asset\AssetStatusQueryParam $status Required when retrieving a collection of assets. See Asset Status Codes (required)
     * @param  int $page Results are paged. This specifies which page of the results to return. The default page is 1. (optional)
     * @param  int $page_size The number of records returned per page. By default the number of records returned is 10. (optional)
     * @param  string $order_by Requests can be ordered by AssetType, AssetName, AssetNumber, PurchaseDate and PurchasePrice. If the asset status is DISPOSED it also allows DisposalDate and DisposalPrice. (optional)
     * @param  string $sort_direction ASC or DESC (optional)
     * @param  string $filter_by A string that can be used to filter the list to only return assets containing the text. Checks it against the AssetName, AssetNumber, Description and AssetTypeName fields. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAssetsAsync($xero_tenant_id, $status, $page = null, $page_size = null, $order_by = null, $sort_direction = null, $filter_by = null)
    {
        return $this->getAssetsAsyncWithHttpInfo($xero_tenant_id, $status, $page, $page_size, $order_by, $sort_direction, $filter_by)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getAssetsAsyncWithHttpInfo
     * searches fixed asset
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\Asset\AssetStatusQueryParam $status Required when retrieving a collection of assets. See Asset Status Codes (required)
     * @param  int $page Results are paged. This specifies which page of the results to return. The default page is 1. (optional)
     * @param  int $page_size The number of records returned per page. By default the number of records returned is 10. (optional)
     * @param  string $order_by Requests can be ordered by AssetType, AssetName, AssetNumber, PurchaseDate and PurchasePrice. If the asset status is DISPOSED it also allows DisposalDate and DisposalPrice. (optional)
     * @param  string $sort_direction ASC or DESC (optional)
     * @param  string $filter_by A string that can be used to filter the list to only return assets containing the text. Checks it against the AssetName, AssetNumber, Description and AssetTypeName fields. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getAssetsAsyncWithHttpInfo($xero_tenant_id, $status, $page = null, $page_size = null, $order_by = null, $sort_direction = null, $filter_by = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\Asset\Assets';
        $request = $this->getAssetsRequest($xero_tenant_id, $status, $page, $page_size, $order_by, $sort_direction, $filter_by);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        AssetObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAssets'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\Asset\AssetStatusQueryParam $status Required when retrieving a collection of assets. See Asset Status Codes (required)
     * @param  int $page Results are paged. This specifies which page of the results to return. The default page is 1. (optional)
     * @param  int $page_size The number of records returned per page. By default the number of records returned is 10. (optional)
     * @param  string $order_by Requests can be ordered by AssetType, AssetName, AssetNumber, PurchaseDate and PurchasePrice. If the asset status is DISPOSED it also allows DisposalDate and DisposalPrice. (optional)
     * @param  string $sort_direction ASC or DESC (optional)
     * @param  string $filter_by A string that can be used to filter the list to only return assets containing the text. Checks it against the AssetName, AssetNumber, Description and AssetTypeName fields. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getAssetsRequest($xero_tenant_id, $status, $page = null, $page_size = null, $order_by = null, $sort_direction = null, $filter_by = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getAssets'
            );
        }
        // verify the required parameter 'status' is set
        if ($status === null || (is_array($status) && count($status) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $status when calling getAssets'
            );
        }
        $resourcePath = '/Assets';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($status !== null) {
            $queryParams['status'] = AssetObjectSerializer::toQueryValue($status);
        }
        // query params
        if ($page !== null) {
            $queryParams['page'] = AssetObjectSerializer::toQueryValue($page);
        }
        // query params
        if ($page_size !== null) {
            $queryParams['pageSize'] = AssetObjectSerializer::toQueryValue($page_size);
        }
        // query params
        if ($order_by !== null) {
            $queryParams['orderBy'] = AssetObjectSerializer::toQueryValue($order_by);
        }
        // query params
        if ($sort_direction !== null) {
            $queryParams['sortDirection'] = AssetObjectSerializer::toQueryValue($sort_direction);
        }
        // query params
        if ($filter_by !== null) {
            $queryParams['filterBy'] = AssetObjectSerializer::toQueryValue($filter_by);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = AssetObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(AssetObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostAsset() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
