<?php
$posts = get_sub_field('posts');

if($posts) {
    $defaultImage = \Blue2\Scruffy\Site::getDefaultImage();
    $title = get_sub_field('title');
    $colour = get_sub_field('colour');
    ?>
    <section class="custom-flexible-section posts-section <?= 'color-' . $colour; ?>">
        <div class="contain">
            <?php if($title) { ?><h2 class="fw-500 text-center"><?= $title; ?></h2><?php } ?>
            <div class="posts-output">
                <div class="row row-eq-height">
                    <?php foreach($posts as $post) {
                        if(get_post_thumbnail_id($post->ID)){
                            $imageDetails = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), "flexible-space-blocks");
                            $image = '<img src=" ' . $imageDetails[0] . '" alt="'. get_the_title($post->ID) .'">';
                            $imageClass = 'featured-image';
                        } else {
                            $image = $defaultImage;
                            $imageClass = 'default-image';
                        }
                        ?>
                        <div class="post-col col-lg-4">
                            <div class="post-inner">
                                <div class="image-wrapper <?= $imageClass; ?>">
                                    <?= $image; ?>
                                </div>
                                <div class="content-wrapper">
                                    <h3 class="fw-500"><?= $post->post_title; ?></h3>
                                    <div class="description"><?= get_the_excerpt($post->ID); ?></div>
                                    <div class="cta">
                                        <a href="<?= get_the_permalink($post->ID); ?>" class="u-case fw-700">Read more</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } wp_reset_postdata(); ?>
                </div>
            </div>

        </div>
    </section>
<?php } ?>
