<?php

namespace Blue2\Scruffy\Controllers;

use Exception;
use League\OAuth2\Client\Provider\GenericProvider;
use League\OAuth2\Client\Provider\Exception\IdentityProviderException;
use XeroAPI\XeroPHP\Configuration;
use XeroAPI\XeroPHP\Api\IdentityApi;
use GuzzleHttp\Client;
use SidneyAllen\XeroPHP\AccountingApiTest;
use XeroAPI\XeroPHP\Api\AccountingApi;
use XeroAPI\XeroPHP\Models\Accounting\Invoice;
use XeroAPI\XeroPHP\Models\Accounting\Invoices;
use XeroAPI\XeroPHP\Models\Accounting\Payment;
use XeroAPI\XeroPHP\Models\Accounting\Contact;
use XeroAPI\XeroPHP\Models\Accounting\LineItem;


class XeroController
{
    //live data
    // const XERO_CLIENT_ID = "E7F13D4DD11B4CC3B2BDB067CB7B4018";
    // const XERO_CLIENT_SECRET = "9ITtiRIuuYqtqL87pmkr-KnhCfqk6p6sxqtdtTBCHEdLz--Y";
    // const XERO_CALLBACK_URI = "https://www.scottishenergyforum.org/wp-json/circle/v1/oauth-callback";
    //test data
    const XERO_CLIENT_ID = "2166F6B7E3014C7EA707A3F3E3B7DE30";
    const XERO_CLIENT_SECRET = "3b6cWmZ1ErpxWUB1tFTRydF9SaTXzGzyoXAWy_MMW-XLD-ZA";
    const XERO_CALLBACK_URI = "https://the-circle.test/wp-json/circle/v1/oauth-callback";
    const XERO_ACCOUNT_CODE = '4000';
    public $xeroTenantId = '';

    public function __construct()
    {
        add_action('wp_dashboard_setup', [$this, 'addXeroWidget']);

        add_action('rest_api_init', function () {
            register_rest_route('circle/v1', '/testApi/', [
                'methods' => 'GET',
                'callback' => [$this, 'xeroTest'],
            ]);
        });

        add_action('rest_api_init', function () {
            register_rest_route('circle/v1', '/xero-authentication/', [
                'methods' => 'GET',
                'callback' => [$this, 'getXeroAuthorization'],
            ]);
        });
        add_action('rest_api_init', function () {
            register_rest_route('circle/v1', '/oauth-callback/', [
                'methods' => 'GET',
                'callback' => [$this, 'xeroOAuthCallback'],
            ]);
        });

        add_action('rest_api_init', function () {
            register_rest_route('circle/v1', '/import-xero-contact/', [
              'methods' => 'GET',
              'callback' => [$this, 'importAllContactFromXero'],
          ]);
        });

        $this->xeroTenantId = get_field('tenant_id', 'option');
    }


    public function addXeroWidget()
    {
        global $wp_meta_boxes;
        if (current_user_can('administrator')) {
            wp_add_dashboard_widget('addXeroWidgetOAuth', 'Xero Authentication', [$this, 'xeroOAuthForm']);
            wp_add_dashboard_widget('addXeroWidgetTest', 'Test Xero', [$this, 'xeroTestForm']);
        }
    }

    public function xeroOAuthForm() { ?>
        <form action="/wp-json/circle/v1/xero-authentication" method="GET" name="xeroOAuth">
            <p>Renew the authorization with xero. Don't touch until is necessary.</p>
            <input class="button button-primary " type="submit" name="xeroAuth" value="Renew Xero Authentication">
        </form>
      <?php
    }
    
    public function xeroTestForm(){ ?>
        <form action="/wp-json/circle/v1/testApi" method="GET" name="xeroTest">
            <p>xeroTest.</p>
            <input class="button button-primary " type="submit" name="xeroAuth" value="xeroTest">
        </form>
        <?php
    }

    public function xeroImportForm() { ?>
            <p>Import all xero user's details</p>
            <div id="importXeroContacts" class="button button-primary">Import Contacts</div>
            <script>
                jQuery(document).ready(function(){
                    jQuery('#importXeroContacts').click(function(){
                        jQuery.ajax({
                            url : "/wp-json/circle/v1/import-xero-contact",
                            success: function(data){
                                alert(data.response);
                            }
                        })
                    })
                })
            </script>
      <?php
    }

    public function getXeroAuthorization()
    {
        $provider = new GenericProvider([
            'clientId'                => self::XERO_CLIENT_ID,
            'clientSecret'            => self::XERO_CLIENT_SECRET,
            'redirectUri'             => self::XERO_CALLBACK_URI,
            'urlAuthorize'            => 'https://login.xero.com/identity/connect/authorize',
            'urlAccessToken'          => 'https://identity.xero.com/connect/token',
            'urlResourceOwnerDetails' => 'https://api.xero.com/api.xro/2.0/Organisation'
          ]);
        
        $options = [
              'scope' => ['openid email profile offline_access assets projects accounting.settings accounting.transactions accounting.contacts accounting.journals.read accounting.reports.read accounting.attachments']
          ];
        
        // This returns the authorizeUrl with necessary parameters applied (e.g. state).
        $authorizationUrl = $provider->getAuthorizationUrl($options);
        if(session_id() == ''){
            session_start();
        }
        // Save the state generated for you and store it to the session.
        // For security, on callback we compare the saved state with the one returned to ensure they match.
        $_SESSION['oauth2state'] = $provider->getState();
        
        // Redirect the user to the authorization URL.
        header('Location: ' . $authorizationUrl);
        exit();
    }

    public function xeroOAuthCallback()
    {
        if(session_id() == ''){
            session_start();
        }
        $provider = new GenericProvider([
            'clientId'                => self::XERO_CLIENT_ID,
            'clientSecret'            => self::XERO_CLIENT_SECRET,
            'redirectUri'             => self::XERO_CALLBACK_URI,
            'urlAuthorize'            => 'https://login.xero.com/identity/connect/authorize',
            'urlAccessToken'          => 'https://identity.xero.com/connect/token',
            'urlResourceOwnerDetails' => 'https://api.xero.com/api.xro/2.0/Organisation'
          ]);
        
        // If we don't have an authorization code then get one
        if (!isset($_GET['code'])) {
            echo "Something went wrong, no authorization code found";
            exit("Something went wrong, no authorization code found");
        
        // Check given state against previously stored one to mitigate CSRF attack
        } elseif (empty($_GET['state']) || ($_GET['state'] !== $_SESSION['oauth2state'])) {
            echo "Invalid State";
            unset($_SESSION['oauth2state']);
            exit('Invalid state');
        } else {
            try {
                // Try to get an access token using the authorization code grant.
                $accessToken = $provider->getAccessToken('authorization_code', [
                'code' => $_GET['code']
              ]);
        
                $config = Configuration::getDefaultConfiguration()->setAccessToken((string)$accessToken->getToken());
                $identityInstance = new IdentityApi(
                    new Client(),
                    $config
                );
        
                $result = $identityInstance->getConnections();
                      
                update_field('token', $accessToken->getToken(), 'option');
                update_field('expires', $accessToken->getExpires(), 'option');
                update_field('tenant_id', $result[0]->getTenantId(), 'option');
                update_field('refresh_token', $accessToken->getRefreshToken(), 'option');
                update_field('id_token', $accessToken->getValues()["id_token"], 'option');
            
                wp_send_json(["response" => "Token updated"]);
                exit();
            } catch (IdentityProviderException $e) {
                wp_send_json(["response" => "There was an error on updating the token"]);
                exit();
            }
        }
    }
    
    public function updateOrCreateInvoices($contactId, $product, $accountCode=400, $total)
	{
        self::refreshTokenIfExpired();
        $config = Configuration::getDefaultConfiguration()->setAccessToken(get_field('token', 'option'));

        $apiInstance = new AccountingApi(
            new Client(),
            $config
        );
        $xero_tenant_id =  get_field('tenant_id', 'option');
        $invoiceDate = \DateTime::createFromFormat('Y/m/d', date("Y/m/d"));
        $invoiceDate = $invoiceDate->format('Y-m-d');

        $formattedProducts = [];
        
        foreach($product as $p){
            $lineItem = new \XeroAPI\XeroPHP\Models\Accounting\LineItem;
            $lineItem->setDescription($p['name']);
            $lineItem->setQuantity(intVal($p['quantity']));
            $lineItem->setUnitAmount(intVal($p['total']));
            $lineItem->setAccountCode('400');
            $lineItem->setTaxType('NONE');
            array_push($formattedProducts, $lineItem);
        }
        

        
        $invoiceObj = [
          (object)[
            "Type" => "ACCREC",
            "Contact" => (object)[
              "ContactID" => $contactId,
            ],
            "LineItems" => $formattedProducts,
            "Date" => date("Y-m-d"),
            "DueDate" => $invoiceDate,
            "Reference" => "circle Purchase Agreement",
            "Status" => \XeroAPI\XeroPHP\Models\Accounting\Invoice::STATUS_AUTHORISED
          ]
        ];
                
        $invoices = new Invoices(["invoices" => $invoiceObj]);

        try {
            $invoice = $apiInstance->createInvoices($xero_tenant_id, $invoices, true, 4);
            $invoiceId = $invoice->getInvoices()[0]->getInvoiceId();
            $invoiceNameOnXero = $invoice->getInvoices()[0]->getInvoiceNumber();

            $acc = $apiInstance->getAccounts($xero_tenant_id);
            $accId = $acc->getAccounts()[0]->getAccountId();
            $account = new \XeroAPI\XeroPHP\Models\Accounting\Account;
            $account->setAccountId($accId);

            $newinvoice = new \XeroAPI\XeroPHP\Models\Accounting\Invoice;
            $newinvoice->setInvoiceID($invoiceId);

            $payment = new \XeroAPI\XeroPHP\Models\Accounting\Payment;
            $payment->setInvoice($newinvoice);
            $payment->setAccount($account);
            $payment->setAmount($total);
            $payment->setDate($invoiceDate);

            $payments = new \XeroAPI\XeroPHP\Models\Accounting\Payments;
            $arr_payments = [];
            array_push($arr_payments, $payment);
            $payments->setPayments($arr_payments);

            $makePay = $apiInstance->createPayment($xero_tenant_id, $payment);

            return json_encode(["response" => "success", [
                'invoiceID' => $invoiceId,
                'invoiceNameOnXero' => $invoiceNameOnXero
            ]]);
        } catch (\Exception $e) {
            return json_encode(["response" => $e->__toString()]);
        }
	}	

    public function getContact($contact){
		self::refreshTokenIfExpired();
        $config = Configuration::getDefaultConfiguration()->setAccessToken(get_field('token', 'option'));

        $apiInstance = new AccountingApi(
            new Client(),
            $config
        );
        $str = '';

        try{
            $new = $this->createContacts($apiInstance, $contact); 
            $contactId = $new->getContacts()[0]->getContactId();
            return $contactId;
        }catch(Exception $e){
            return $e->getMessage();
            
        }
	}

    public function createContacts($apiInstance, $contact)
	{
        self::refreshTokenIfExpired();
        $formattedContacts = [];

        $newContact = new \XeroAPI\XeroPHP\Models\Accounting\Contact;
        if($contact['id'] !== 0){
            $newContact->setName($contact['first_name'] . ' ' . $contact['last_name'])
            ->setFirstName($contact['first_name'])
            ->setLastName($contact['last_name'])
            ->setEmailAddress($contact['email_address']);
        }else{
            $newContact->setName('Fake User' . $this->getRandNum())
            ->setFirstName("Fake" . $this->getRandNum())
            ->setLastName("User" . $this->getRandNum())
            ->setEmailAddress("richie@blue2.co.uk");
        }
        
        array_push($formattedContacts, $newContact);


        $contacts = new \XeroAPI\XeroPHP\Models\Accounting\Contacts;
        $contacts->setContacts($formattedContacts);

        try{
            $result = $apiInstance->createContacts($this->getTenantId(), $contacts); 

            return $result;
        }catch(Exception $e){
            return $e->getMessage();
        }
        
	}

    

    

    /* REMOVE MEEEEE!!!! */
    public function getRandNum()
	{
		$randNum = strval(rand(1000,100000)); 

		return $randNum;
	}
    /* REMOVE MEEEEE!!!! */



    public function xeroTest(){
        $order = wc_get_order( '249' );
        $user = [
            'id'            => $order->get_customer_id(),
            'first_name'    => $order->get_billing_first_name(),
            'last_name'     => $order->get_billing_last_name(),
            'email_address' => $order->get_billing_email()
        ];
        $contact = $this->getContact($user);

        $total = $order->get_total();
        $items = $order->get_items();
        $products = [];
        foreach ( $items as $item ) {
            $products[] = [
                'id'        => $item->get_product_id(),
                'name'      => $item->get_name(),
                'quantity'  => $item->get_quantity(),
                'subtotal'  => number_format($item->get_subtotal(), 2),
                'total'     => number_format($item->get_total(), 2),
                

            ];
        }
        if($contact){
            $this->updateOrCreateInvoices($contact, $products, 400, $total);
        }
    }

    public function orderSuccess($orderID){
        $order = wc_get_order($orderID);

        $user = [
            'id'            => $order->get_customer_id(),
            'first_name'    => $order->get_billing_first_name(),
            'last_name'     => $order->get_billing_last_name(),
            'email_address' => $order->get_billing_email()
        ];
        $contact = $this->getContact($user);

        $total = $order->get_total();
        $items = $order->get_items();
        $products = [];
        foreach ( $items as $item ) {
            $products[] = [
                'id'        => $item->get_product_id(),
                'name'      => $item->get_name(),
                'quantity'  => $item->get_quantity(),
                'subtotal'  => number_format($item->get_subtotal(), 2),
                'total'     => number_format($item->get_total(), 2),
                

            ];
        }
        if($contact){
            $this->updateOrCreateInvoices($contact, $products, 400, $total);
        }
    }

    public static function refreshTokenIfExpired()
    {
        $tokenExpired = true;
        $tokenExpireTime = get_field('expires', 'option');
        if ($tokenExpireTime) {
            if (time() > $tokenExpireTime) {
                $tokenExpired = true;
            } else {
                $tokenExpired = false;
            }
        } else {
            $tokenExpired = true;
        }
        
        if ($tokenExpired) {
            $provider = new \League\OAuth2\Client\Provider\GenericProvider([
            'clientId'                => self::XERO_CLIENT_ID,
            'clientSecret'            => self::XERO_CLIENT_SECRET,
            'redirectUri'             => self::XERO_CALLBACK_URI,
            'urlAuthorize'            => 'https://login.xero.com/identity/connect/authorize',
            'urlAccessToken'          => 'https://identity.xero.com/connect/token',
            'urlResourceOwnerDetails' => 'https://api.xero.com/api.xro/2.0/Organisation'
          ]);
      
            $newAccessToken = $provider->getAccessToken('refresh_token', [
            'refresh_token' => get_field('refresh_token', 'option')
          ]);
            update_field('token', $newAccessToken->getToken(), 'option');
            update_field('expires', $newAccessToken->getExpires(), 'option');
            update_field('refresh_token', $newAccessToken->getRefreshToken(), 'option');
            update_field('id_token', $newAccessToken->getValues()["id_token"], 'option');
        }
    }

    private function getTenantId(){
        return get_field('tenant_id', 'option');
    }
}
