<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;
?>
<div class="contain">
    <?php
    /**
     * Hook: woocommerce_before_single_product.
     *
     * @hooked woocommerce_output_all_notices - 10
     */
    do_action( 'woocommerce_before_single_product' );
    ?>
</div>

<?php
if ( post_password_required() ) {
    echo get_the_password_form(); // WPCS: XSS ok.
    return;
}

$building = get_the_terms(get_the_id(), 'building');
$location = get_the_terms(get_the_id(), 'location');
$defaultImage = \Blue2\Scruffy\Site::getDefaultImage();
$features = get_field('attributes');
$galleryImages = $product->get_gallery_image_ids();
$meta = get_post_meta(get_the_id());
$terms = get_the_terms(get_the_id(), 'product_cat');
$bookingSettings = get_post_meta(get_the_id(),'woocommerce_booking_settings',true);
?>
<div id="product-<?php the_ID(); ?>" <?php wc_product_class( '', $product ); ?>>
    <div class="custom-single-product">
        <section class="top-section">

            <?php if(get_the_post_thumbnail_url()) { ?>
                <div class="featured-image-holder">
                    <div class="inner-wrap">
                        <img src="<?php the_post_thumbnail_url(); ?>" alt="<?php the_title(); ?>" class="featured-image">
                    </div>
                </div>
            <?php } ?>

            <div class="contain">
                <div class="custom-single-product">
                    <div class="row">
                        <div class="col-lg-5">
                            <div class="content-wrapper">

                                <div class="title-holder d-flex justify-content-between align-items-center">
                                    <h1 class="fw-500"><?php the_title(); ?></h1>
                                    <div class="price">
                                        <?= get_woocommerce_currency_symbol() . number_format($product->get_price(), 2, '.', ''); ?>
                                        <?php if($bookingSettings !== "") { ?>
                                            <span class="frequency">/ <?= $bookingSettings['bkap_duration_settings']['duration'] . " " . $bookingSettings['bkap_duration_settings']['duration_type']; ?></span>
                                        <?php } elseif(!has_term('publications', 'product_cat')) { ?>
                                            <span class="frequency">/ sqft</span>
                                        <?php } ?>
                                    </div>
                                </div>

                                <?php if($building || $location) { ?>
                                    <div class="space-attributes">
                                        <ul>
                                            <?php if($building) { ?><li><?= $building[0]->name; ?></li><?php } ?>
                                            <?php if($location) { ?><li><?= $location[0]->name; ?></li><?php } ?>
                                        </ul>
                                    </div>
                                <?php } ?>

                                <div class="description">
                                    <?php the_content(); ?>

                                    <div class="custom-buttons">
                                        <a href="/enquiry/" class="enquire-button fw-700 u-case">Enquire Now</a>

                                        <?php $libraryTerm = get_term_by('slug', 'shop', 'product_cat');
                                        if($terms[0]->parent == $libraryTerm->term_id){
                                            $add_to_cart = do_shortcode('[add_to_cart_url id="'. get_the_id() .'"]'); ?>
                                            <a href="<?= $add_to_cart; ?>" class="u-case fw-700">Buy now</a>
                                        <?php } ?>

                                        <?php if($galleryImages) { ?>
                                            <a href="#gallery" class="gallery-button fw-700 u-case">Gallery</a>
                                        <?php } ?>
                                    </div>


                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <?php if($features) { ?>
            <section class="features">
                <div class="contain">
                    <div class="features-inner">
                        <?php foreach($features as $feature) { ?>
                            <div class="feature">
                                <h3><span class="far <?= $feature['icon']; ?>"></span> <?= $feature['title']; ?></h3>
                                <div class="description"><?= $feature['description']; ?></div>
                            </div>
                        <?php } ?>
                    </div>

                    <div class="enquire-cta text-center">
                        <a href="/enquiry/" class="enquire-button fw-700 u-case">Enquire Now</a>
                    </div>
                </div>
            </section>
        <?php } ?>

        <?php if($bookingSettings !== "") { 
            ob_start();
            do_action( 'woocommerce_single_product_summary' );
            $content = ob_get_contents();
            ob_end_clean();
            $obContent = trim($Content);
            if (!empty($obContent)) {
        ?>
            <section class="booking-section">
                <div class="contain">
                    <h2 class="fw-500 text-center">Booking</h2>
                    <div class="offset-lg-2 col-lg-8">
                        <div class="booking-holder">
                            <?php
                            /**
                             * Hook: woocommerce_single_product_summary.
                             *
                             * @hooked woocommerce_template_single_title - 5
                             * @hooked woocommerce_template_single_rating - 10
                             * @hooked woocommerce_template_single_price - 10
                             * @hooked woocommerce_template_single_excerpt - 20
                             * @hooked woocommerce_template_single_add_to_cart - 30
                             * @hooked woocommerce_template_single_meta - 40
                             * @hooked woocommerce_template_single_sharing - 50
                             * @hooked WC_Structured_Data::generate_product_data() - 60
                             */
                            echo $content;
                            ?>
                        </div>
                    </div>
                </div>
            </section>
        <?php 
            }
        } ?>

        <?php
        if($galleryImages) { ?>
            <section class="gallery" id="gallery">
                <div class="contain">
                    <h2 class="fw-500 text-center">Gallery</h2>
                    <div class="gallery-grid">
                        <?php foreach($galleryImages as $id) {
                            $image = wp_get_attachment_image_src($id, 'full'); ?>
                            <div class="gallery-item">
                                <img src="<?= $image[0] ?>" alt="" loading="lazy">
                            </div>
                        <?php } ?>
                    </div>
                    <div class="enquire-cta text-center">
                        <a href="/enquiry/" class="enquire-button fw-700 u-case">Enquire Now</a>
                    </div>
                </div>
            </section>
        <?php } ?>

        <?php
        $title = get_field('title') ?: 'Location';
        $description = get_field('description');
        $gettingHere = get_field('getting_here');
        $busRoutes = get_field('bus_routes');
        $mapLocation = get_field('google_map_location');

        if($description || $gettingHere || $busRoutes || $mapLocation) { ?>
            <section class="location">
                <div class="contain">
                    <h2 class="text-center fw-500"><?= $title; ?></h2>
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="location-description">
                                <?= $description; ?>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <?php if($gettingHere) { ?>
                                <h3>Getting here</h3>
                                <div class="getting-here-description"><?= $gettingHere; ?></div>
                            <?php }
                            if($busRoutes) { ?>
                                <ul class="bus-routes">
                                    <?php foreach($busRoutes as $route) { ?>
                                        <li><a href="<?= $route['url']; ?>" target="_blank"><span class="far fa-bus-alt"></span><?= $route['name']; ?></a></li>
                                    <?php } ?>
                                </ul>
                            <?php } ?>
                        </div>
                    </div>

                    <?php if($mapLocation) { ?>
                        <div id="map" data-lat="<?= $mapLocation['lat']; ?>" data-lng="<?= $mapLocation['lng']; ?>" data-zoom="<?= $mapLocation['zoom']; ?>"></div>
                    <?php } ?>
                </div>
            </section>
        <?php } ?>

    </div>
</div>

<?php do_action( 'woocommerce_after_single_product' ); ?>
