<?php
$heroType = get_sub_field('hero_type');
$title = get_sub_field('title');
$description = get_sub_field('description');
$cta = get_sub_field('call_to_action');
$heroAutoPlay = get_sub_field('hero_autoplay');
?>
<section class="custom-flexible-section hero-section">
    <?php if($heroType == 'image') {
        $imageID = get_sub_field('image')['id'];
        $image = wp_get_attachment_image_src($imageID, 'banner-image'); ?>
        <img src="<?= $image[0]; ?>">
    <?php } else {
        $video = get_sub_field('video'); 
        if($heroAutoPlay){
            $status = 'play';
            $autoplay = "autoplay";
            $playBtnClass = 'd-block d-sm-none';
        }else{
            $status = 'paused';
            $autoplay = '';
            $playBtnClass = '';
        }
        ?>
        <video data-status="<?=$status;?>" id="hero-video" <?=$autoplay;?> muted loop>
            <source src="<?= $video['url']; ?>" type="video/mp4">
        </video>

        <div id="video-toggle">
            <div class="contain">
                <div class="action <?=$playBtnClass;?>">
                    <span class="fa-stack fa-2x">
                       <span class="fas fa-circle fa-stack-2x"></span>
                       <span class="fas fa-play fa-stack-1x fa-inverse action-toggle"></span>
                    </span>
                    <span class="text">Play video</span>
                </div>
            </div>
        </div>
    <?php 
        } ?>
    <div class="content-wrapper">
        <div class="contain">
            <div class="content-block">
                <h1><?= $title; ?></h1>
                <?php if($description) { ?><div class="description"><?= $description; ?></div><?php } ?>
                <?php if($cta) { ?><a href="<?= $cta['url']; ?>" class="u-case fw-700" target="<?= $cta['target']; ?>"><span class="text"><?= $cta['title']; ?></span></a><?php } ?>
            </div>
        </div>
    </div>
</section>
