<?php
$titleType = get_sub_field('title_type');
$imageType = get_sub_field('image_type');
$color = get_sub_field('colour');
$title = $titleType == 'page-title' ? get_the_title() : get_sub_field('title');
$imageID = $imageType == 'featured' ? get_post_thumbnail_id() : get_sub_field('image')['id'];
$titleClass = !$imageID && $imageType == 'none' ? 'image-not-set' : "";
?>
<section class="custom-flexible-section title-section <?= 'color-' . $color; ?>">
    <div class="contain">
        <h1 class="fw-500 <?= $titleClass; ?>"><?= $title; ?></h1>
        <?php if($imageID && $imageType !== 'none') {
            $imageDetails = wp_get_attachment_image_src($imageID, "flexible-title-image");
            $image = '<img src=" ' . $imageDetails[0] . '" alt="'. $title .'">';
            ?>
            <div class="image-wrapper">
                <?= $image; ?>
            </div>
        <?php } ?>
    </div>
</section>
