<?php
$defaultImage = \Blue2\Scruffy\Site::getDefaultImage();
$title = get_sub_field('title');
$description = get_sub_field('description');
$image = get_sub_field('image');

if($image){
    $imageDetails = wp_get_attachment_image_src($image['id'], "");
    $image = '<img src=" ' . $imageDetails[0] . '" alt="'. $image['alt'] .'">';
    $imageClass = 'featured-image';
} else {
    $image = $defaultImage;
    $imageClass = 'default-image';
}

$spaces = get_term_by('slug', 'spaces', 'product_cat');

$locations = get_terms('location', ['hide_empty' => false]);
$categories = get_terms('product_cat', ['hide_empty' => false, 'parent' => $spaces->term_id]);

?>
<section class="custom-flexible-section spaces-filter-section">
    <div class="contain">

        <div class="row">
            <div class="col-lg-6 content-col d-flex align-items-center">
                <div class="content-wrapper">
                    <?php if($title) { ?><h2 class="fw-500"><?= $title; ?></h2><?php } ?>
                    <?php if($description) { ?><div class="description"><?= $description; ?></div><?php } ?>
                    <form action="/product-category/spaces/">
                        <div class="select-holder">
                            <div class="chevron-holder">
                                <span class="fas fa-chevron-down"></span>
                            </div>
                            <label for="locations">Location</label>
                            <select name="location" id="locations">
                                <?php foreach($locations as $location) { ?>
                                    <option value="<?= $location->slug; ?>"><?= $location->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="select-holder">
                            <div class="chevron-holder">
                                <span class="fas fa-chevron-down"></span>
                            </div>
                            <label for="spaces">Type of space</label>
                            <select name="space" id="spaces">
                                <?php foreach($categories as $cat) { ?>
                                    <option value="<?= $cat->slug; ?>"><?= $cat->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <input type="submit" value="Search" class="fw-700 u-case">
                    </form>
                </div>
            </div>
            <div class="col-lg-6 image-col">
                <div class="image-wrapper <?= $imageClass; ?>">
                    <?= $image; ?>
                </div>
            </div>
        </div>

    </div>
</section>
