<?php
$spaces = get_sub_field('spaces');
$defaultImage = \Blue2\Scruffy\Site::getDefaultImage();

if($spaces) { ?>
    <section class="custom-flexible-section spaces-section">
        <div class="contain">
            <h2 class="text-center fw-500">Available Spaces</h2>

            <div class="available-spaces">
                <div class="row row-eq-height d-flex justify-content-center">
                    <?php foreach($spaces as $space) {
                        $building = get_the_terms($space->ID, 'building');
                        $location = get_the_terms($space->ID, 'location');

                        if(get_post_thumbnail_id($space->ID)){
                            $imageDetails = wp_get_attachment_image_src(get_post_thumbnail_id($space->ID), "flexible-space-blocks");
                            $image = '<img src=" ' . $imageDetails[0] . '" alt="'. get_the_title($space->ID) .'">';
                            $imageClass = 'featured-image';
                        } else {
                            $image = $defaultImage;
                            $imageClass = 'default-image';
                        }

                        $stockStatus = get_post_meta( $space->ID, '_stock_status', true );
                        $stockStatusText = $stockStatus == 'instock' ? 'Available' : 'Unavailable';
                        $stockStatusClass = $stockStatus == 'instock' ? 'in-stock' : 'no-stock';

                        $buttonText = get_field('text_override_spaces_section_button', $space->ID) ?: 'Find out more';

                        ?>
                        <div class="col-md-6 col-lg-4 col-xl-3 space-col">
                            <div class="inner-space <?= $stockStatusClass; ?>">
                                <div class="image-wrapper <?= $imageClass; ?>">
                                    <div class="availability fw-700"><?= $stockStatusText; ?></div>
                                    <?= $image; ?>
                                </div>
                                <div class="content-wrapper">
                                    <?php if($building || $location) { ?>
                                        <div class="space-attributes">
                                            <ul>
                                                <?php if($building) { ?><li><?= $building[0]->name; ?></li><?php } ?>
                                                <?php if($location) { ?><li><?= $location[0]->name; ?></li><?php } ?>
                                            </ul>
                                        </div>
                                    <?php } ?>

                                    <h3 class="fw-500"><?= $space->post_title; ?></h3>
                                    <div class="description"><?= get_the_excerpt($space->ID); ?></div>
                                    <a href="<?= get_the_permalink($space->ID); ?>"  class="<?= $stockStatus !== 'instock' ? 'isDisabled' : ""; ?> u-case fw-700"><?= $buttonText; ?></a>

                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>

        </div>
    </section>
<?php } ?>
