<?php
$spaces = get_term_by('slug', 'spaces', 'product_cat');
$category = get_terms('product_cat', ['hide_empty' => false, 'parent' => $spaces->term_id]);
$locations = get_terms('location', ['hide_empty' => false]);
$roomCapacity = get_terms('capacity', ['hide_empty' => false, 'order' => 'ASC', 'orderby' => 'name']);
$capacity = [];
foreach($roomCapacity as $room) {
    $capacity[] = $room->slug;
}
sort($capacity);
?>
<div class="spaces-filter">
    <div class="contain">
        <form class="filter-form">
            <div class="select-holder">
                <select name="space">
                    <option value="">All Spaces</option>
                    <?php foreach($category as $space) {
                        $selectedSpace = isset($_GET['space']) && $_GET['space'] == $space->slug ? 'selected' : "";
                        ?>
                        <option value="<?= $space->slug ?>" <?= $selectedSpace ?>><?= ucwords(strtolower($space->name));  ?></option>
                    <?php } ?>
                </select>
                <div class="custom-select-arrow"><span class="fas fa-chevron-down"></span></div>
            </div>
            <div class="select-holder">
                <select name="location">
                    <option value="">All Locations</option>
                    <?php foreach($locations as $location) {
                        $selectedLocation = isset($_GET['location']) && $_GET['location'] == $location->slug ? 'selected' : "";
                        ?>
                        <option value="<?= $location->slug ?>" <?= $selectedLocation; ?>><?= $location->name; ?></option>
                    <?php } ?>
                </select>
                <div class="custom-select-arrow"><span class="fas fa-chevron-down"></span></div>
            </div>

            <div class="select-holder">
                <select name="capacity">
                    <option value="">All Room Capacities</option>
                    <?php foreach($capacity as $cap) {
                        $selectedCapacity = isset($_GET['capacity']) && $_GET['capacity'] == $cap ? 'selected' : "";
                        ?>
                        <option value="<?= $cap ?>" <?= $selectedCapacity; ?>>Capacity: <?= $cap; ?></option>
                    <?php } ?>
                </select>
                <div class="custom-select-arrow"><span class="fas fa-chevron-down"></span></div>
            </div>
            <input type="submit" class="u-case fw-700" value="Filter Results">
        </form>
    </div>
</div>
