<?php
$defaultImage = \Blue2\Scruffy\Site::getDefaultImage();
$terms = get_the_terms(get_the_id(), 'category');
if(get_post_thumbnail_id()){
    $imageDetails = wp_get_attachment_image_src(get_post_thumbnail_id(), "blog-image");
    $image = '<img src=" ' . $imageDetails[0] . '" alt="'. get_the_title() .'">';
    $imageClass = 'featured-image';
} else {
    $image = $defaultImage;
    $imageClass = 'default-image';
}
?>
<div class="post-col col-lg-4">
    <div class="post-inner">
        <div class="image-wrapper <?= $imageClass; ?>">
            <?= $image; ?>
        </div>
        <div class="content-wrapper">
            <?php if($terms) { ?>
                <div class="category u-case"><?= $terms[0]->name; ?></div>
            <?php } ?>
            <h3 class="fw-500"><?= get_the_title() ?></h3>
            <div class="description"><?= get_the_excerpt(); ?></div>
            <div class="cta">
                <a href="<?= get_the_permalink(); ?>" class="u-case fw-700">Read more</a>
            </div>
        </div>
    </div>
</div>
