<?php
namespace Blue2\Scruffy;

use Blue2\Scruffy\Controllers\EventController;
use Blue2\Scruffy\Controllers\ProductController;

class Site extends \Blue2\Common\Site
{
    public function __construct()
    {
        parent::__construct();


        add_theme_support('post-thumbnails');
        add_theme_support('woocommerce');
        add_action('after_setup_theme', [$this, 'registerMenus']);
        add_filter('excerpt_more', [$this, 'tidyExcerpt']);

        $this->registerShortCodes();
        $this->registerFilters();
        $this->registerActions();
        $this->setupControllers();
    }

    public function registerMenus()
    {
        register_nav_menus([
            'main_menu' => 'Main Menu',
            'footer_menu' => 'Footer Menu',
            'footer_the_circle' => 'Footer "The Circle" Menu',
            'footer_our_spaces' => 'Footer "Our Spaces" Menu',
            'footer_contact_us' => 'Footer "Contact Us" Menu',
        ]);
    }

    public function tidyExcerpt()
    {
        return '...';
    }

    private function registerShortCodes()
    {
        // Empty
    }

    private function registerFilters(){
        add_filter('excerpt_length', [$this, 'my_excerpt_length']);
        add_filter('acf/fields/google_map/api', [$this, 'myAcfGoogleMapApi']);
        add_filter('wp_enqueue_scripts', [$this, 'enqueueScripts']);
    }

    private function registerActions() {
        add_action('init', [$this, 'registerPostTypes']);
        add_action('wp_enqueue_scripts', [$this, 'dequeueStyles'], 100);
        add_action('wp_print_scripts', [$this, 'dequeueScripts'], 100 );
        add_action('login_enqueue_scripts', [$this, 'customLoginStylesheet']);
        add_action('init', [$this, 'customImageSizes']);
    }

    private function setupControllers(){
        new ProductController();
        new EventController();
    }

    public function registerPostTypes()
    {
        Post\Event::registerPostType();
    }

    public function customImageSizes()
    {
        add_image_size('2-wide', 761, 381, true);
        add_image_size('3-wide', 490, 245, true);
        add_image_size('4-wide', 355, 177, true);
        add_image_size('flexible-space-blocks', 355, 266, true);
        add_image_size('service-image', 628, 628, true);
        add_image_size('product-archive-image', 656, 491, true);
        add_image_size('logo-image', 177, 0, false);
        add_image_size('flexible-split-25', 357, 0, false);
        add_image_size('flexible-split-40', 628, 0, false);
        add_image_size('flexible-split-50', 763, 0, false);
        add_image_size('flexible-split-60', 898, 0, false);
        add_image_size('flexible-split-75', 1170, 0, false);
        add_image_size('flexible-title-image', 1576, 0, false);
        add_image_size('blog-image', 490, 245, true);


    }

        public static function getDefaultImage() {
        $path = get_template_directory() . '/dist/images/the-circle-logo-white.svg';
        $file = file_get_contents($path);
        // remove xml header
        $file = str_replace(
            '<?xml version="1.0" encoding="UTF-8"?>',
            '',
            $file
        );
        // add class and attributes for accessibility
        return str_replace(
            '<svg',
            '<svg class="default-logo" role="img" aria-label="The Circle"',
            $file
        );
    }

    function my_excerpt_length($length){
        return 26;
    }

    public function myAcfGoogleMapApi($api)
    {
        $api['key'] = 'AIzaSyA8c9Yr11Q8Iw-XH8lOiLyMKT7tEqET7C0';
        return $api;
    }

    public function enqueueScripts()
    {
        if (is_product()) {
            wp_enqueue_script('google-maps', '//maps.googleapis.com/maps/api/js?key=AIzaSyA8c9Yr11Q8Iw-XH8lOiLyMKT7tEqET7C0', ['jquery'], null, true);
        }
    }

    function dequeueStyles(){
        wp_dequeue_style('wp-block-library');
        wp_dequeue_style('wp-block-library-theme');
        wp_dequeue_style('wc-block-style');
    }

    function dequeueScripts(){
        wp_dequeue_script('jquery-migrate');
    }

    public function customLoginStylesheet()
    {
        wp_enqueue_style('custom-login', get_stylesheet_directory_uri() . '/assets/styles/login.css');
    }
}
