<?php
$categories = get_categories();
$queriedObject = get_queried_object();
?>

<div class="custom-posts-archive">
    <div class="contain">

        <h1><?= is_category() ? get_queried_object()->name : 'Blog' ?></h1>

        <?php if($categories) { ?>
            <ul class="blog-categories">
                <li class="<?= is_home() ? 'active' : 'inactive'; ?> fw-700"><a href="<?= get_permalink( get_option( 'page_for_posts' ) ); ?>">All</a></li>
                <?php foreach($categories as $cat) {
                    $activeClass = $cat->slug == $queriedObject->slug ? 'active' : 'in-active';
                    ?>
                    <li class="<?= $activeClass; ?> fw-700"><a href="<?= get_category_link($cat->term_id); ?>"><?= $cat->name; ?></a></li>
                <?php } ?>
            </ul>
        <?php } ?>

        <div class="row">
            <?php Blue2\Scruffy\Utils::archiveLoop(); ?>
        </div>
    </div>
</div>




