<?php
$heroType = get_sub_field('hero_type');
$title = get_sub_field('title');
$description = get_sub_field('description');
$cta = get_sub_field('call_to_action');
?>
<section class="custom-flexible-section hero-section">
    <?php if($heroType == 'image') {
        $imageID = get_sub_field('image')['id'];
        $image = wp_get_attachment_image_src($imageID, 'banner-image'); ?>
        <img src="<?= $image[0]; ?>">
    <?php } else {
        $video = get_sub_field('video'); ?>
        <video data-status="paused" id="hero-video" muted loop>
            <source src="<?= $video['url']; ?>" type="video/mp4">
        </video>
        <div id="video-toggle">
            <div class="contain">
                <div class="action">
                    <span class="fa-stack fa-2x">
                       <span class="fas fa-circle fa-stack-2x"></span>
                       <span class="fas fa-play fa-stack-1x fa-inverse action-toggle"></span>
                    </span>
                    <span class="text">Play video</span>
                </div>
            </div>
        </div>
    <?php } ?>
    <div class="content-wrapper">
        <div class="contain">
            <div class="content-block">
                <h1><?= $title; ?></h1>
                <?php if($description) { ?><div class="description"><?= $description; ?></div><?php } ?>
                <?php if($cta) { ?><a href="<?= $cta['url']; ?>" class="u-case fw-700" target="<?= $cta['target']; ?>"><span class="text"><?= $cta['title']; ?></span></a><?php } ?>
            </div>
        </div>
    </div>
</section>
