<?php
$eventsField = get_sub_field('events');
$defaultImage = \Blue2\Scruffy\Site::getDefaultImage();

if(!$eventsField) {
    $eventsArgs = [
        'post_type' => 'event',
        'numberposts' => 2,
        'meta_query' => [
            [
                'key' => 'event_date',
                'type' => 'DATE',
                'value' => date("Y-m-d"),
                'compare' => '>=',
            ]
        ],
        'orderby' => 'meta_value',
        'order' => 'ASC'
    ];
    $events = get_posts($eventsArgs);
} else {
    $events = $eventsField;
}

if($events) { ?>
    <section class="custom-flexible-section events-section">
        <div class="contain">
            <h2 class="fw-500 text-center">Events</h2>
            <div class="events-output">
                <div class="row row-eq-height">
                    <?php foreach($events as $event) {
                        if(get_post_thumbnail_id($event->ID)){
                            $imageDetails = wp_get_attachment_image_src(get_post_thumbnail_id($event->ID), "flexible-space-blocks");
                            $image = '<img src=" ' . $imageDetails[0] . '" alt="'. get_the_title($event->ID) .'">';
                            $imageClass = 'featured-image';
                        } else {
                            $image = $defaultImage;
                            $imageClass = 'default-image';
                        }

                        $eventbriteLink = get_field('eventbrite_link', $event->ID);
                        $link = $eventbriteLink  ?: get_the_permalink($event->ID);
                        $linkText = $eventbriteLink ? 'Register Now' : 'View Details';
                        $linkTarget = $eventbriteLink ? '_blank' : '_self';

                        $timeOutput = "";
                        $eventDate = get_field('event_date', $event->ID);
                        $eventStartTime = get_field('event_start_time', $event->ID);
                        $eventEndTime = get_field('event_end_time', $event->ID);

                        if($eventStartTime){
                            $timeOutput = $eventStartTime;
                        }
                        if($eventEndTime) {
                            $timeOutput .= ' - ' . $eventEndTime;
                        }
                        ?>
                        <div class="event-col col-md-6 event-col">
                            <div class="event-inner">
                                <div class="image-wrapper <?= $imageClass; ?>">
                                    <?= $image; ?>
                                </div>
                                <div class="content-wrapper">
                                    <h3 class="fw-500"><a href="<?= get_the_permalink($event->ID); ?>"><?= $event->post_title; ?></a></h3>
                                    <div class="description"><?= get_the_excerpt($event->ID); ?></div>
                                    <div class="event-info">
                                        <div class="start-date"><span class="fas fa-clock"></span><?= $eventDate; ?></div>
                                        <?php if($timeOutput) { ?><div class="time"><span class="fas fa-calendar"></span><?= $timeOutput; ?></div><?php } ?>
                                    </div>
                                    <div class="cta">
                                        <a href="<?= $link; ?>" target="<?= $linkTarget; ?>" class="u-case fw-700"><?= $linkText; ?></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>

        </div>
    </section>
<?php } ?>
