<?php
$members = get_sub_field('team_members');
if($members) {
    $defaultImage = \Blue2\Scruffy\Site::getDefaultImage();
    $title = get_sub_field('section_title');
    ?>
    <section class="custom-flexible-section team-section">
        <div class="contain">
            <h2 class="fw-500 text-center"><?= $title; ?></h2>
            <div class="members-output">
                <div class="row row-eq-height">
                    <?php foreach($members as $member) {

                        if($member['image']){
                            $imageDetails = wp_get_attachment_image_src($member['image']['id'], '');
                            $image = '<img src=" ' . $imageDetails[0] . '" alt="'. $member['image']['alt'] .'">';
                            $imageClass = 'featured-image';
                        } else {
                            $image = $defaultImage;
                            $imageClass = 'default-image';
                        }
                        ?>
                        <div class="col-sm-6 col-lg-4 col-xl-3 member-col">
                            <div class="member-inner">
                                <a data-toggle="modal" data-target="#teamModal" data-name="<?= $member['name']; ?>" data-title="<?= $member['title'] ?>" data-description="<?= $member['description'] ?>">
                                    <div class="image-wrapper <?= $imageClass; ?>">
                                        <?= $image; ?>
                                    </div>
                                    <div class="content-wrapper text-center">
                                        <h3 class="u-case fw-500"><?= $member['name']; ?></h3>
                                        <h4 class="fw-500"><?= $member['title']; ?></h4>
                                    </div>
                                </a>
                            </div>
                        </div>

                    <?php } ?>
                </div>
            </div>
        </div>

        <div class="modal fade" id="teamModal" tabindex="-1" role="dialog" aria-labelledby="teamModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="teamModalLabel"></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <strong class="title"></strong>
                        <div class="description"></div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-primary" data-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>

    </section>
<?php } ?>
