<?php
$ratio = get_sub_field('split_section_ratio');
$primary = get_sub_field('primary');
$secondary = get_sub_field('secondary');
$sectionTitle = get_sub_field('section_title');
$color = get_sub_field('colour');

switch($ratio) {
    case "50-50":
        $primaryCol = 'col-lg-6';
        $secondaryCol = 'col-lg-6';
        $primaryColImageSize = 'flexible-split-50';
        $secondaryColImageSize = 'flexible-split-50';
        break;
    case "40-60":
        $primaryCol = 'col-lg-5';
        $secondaryCol = 'col-lg-7';
        $primaryColImageSize = 'flexible-split-40';
        $secondaryColImageSize = 'flexible-split-60';
        break;
    case "60-40":
        $primaryCol = 'col-lg-7';
        $secondaryCol = 'col-lg-5';
        $primaryColImageSize = 'flexible-split-60';
        $secondaryColImageSize = 'flexible-split-40';
        break;
    case "25-75":
        $primaryCol = 'col-lg-3';
        $secondaryCol = 'col-lg-9';
        $primaryColImageSize = 'flexible-split-25';
        $secondaryColImageSize = 'flexible-split-75';
        break;
    case "75-25":
        $primaryCol = 'col-lg-9';
        $secondaryCol = 'col-lg-3';
        $primaryColImageSize = 'flexible-split-75';
        $secondaryColImageSize = 'flexible-split-25';
        break;
}
?>

<section class="custom-flexible-section split-section <?= 'color-' . $color; ?>">
    <div class="split-section__contain contain">

        <?php if($sectionTitle) { ?>
            <div class="row">
                <div class="col-lg-6 section-title">
                    <h2 class="fw-500"><?= $sectionTitle; ?></h2>
                </div>
            </div>
        <?php } ?>

        <div class="row">
            <div class="primary-col <?= $primaryCol; ?>">
                <div class="custom-content <?= 'inner-' . $primary['content_type']; ?>">
                    <?php switch($primary['content_type']){
                        case 'image':
                            get_template_part('templates/flexible_sections/split-sections/image', 'image-template', ['image' => $primary['image'], 'image_size' => $primaryColImageSize]);
                            break;
                        case 'text':
                            get_template_part('templates/flexible_sections/split-sections/text', 'text-template',  ['text' => $primary['text']]);
                            break;
                        case 'video':
                            get_template_part('templates/flexible_sections/split-sections/video', 'video-template', ['video' => $primary['video']]);
                            break;
                        case 'form':
                            get_template_part('templates/flexible_sections/split-sections/form', 'form-template', ['form' => $primary['form_shortcode']]);
                            break;
                    }
                    ?>
                </div>
            </div>
            <div class="secondary-col <?= $secondaryCol; ?>">
                <div class="custom-content <?= 'inner-' . $secondary['content_type']; ?>">
                    <?php switch($secondary['content_type']){
                        case 'image':
                            get_template_part('templates/flexible_sections/split-sections/image', 'image-template', ['image' => $secondary['image'], 'image_size' => $secondaryColImageSize]);
                            break;
                        case 'text':
                            get_template_part('templates/flexible_sections/split-sections/text', 'text-template', ['text' => $secondary['text']]);
                            break;
                        case 'video':
                            get_template_part('templates/flexible_sections/split-sections/video', 'video-template', ['video' => $secondary['video']]);
                            break;
                        case 'form':
                            get_template_part('templates/flexible_sections/split-sections/form', 'form-template', ['form' => $secondary['form_shortcode']]);
                            break;
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>
</section>
