<?php
namespace Blue2\Scruffy\Controllers;

class ProductController
{
    public function __construct()
    {
        $this->registerActions();
        $this->registerFilters();
    }

    private function registerActions()
    {
        add_action('init', [$this, 'registerTaxonomies']);
    }

    private function registerFilters()
    {
    }

    public function registerTaxonomies()
    {
        $location = new \Blue2\Common\Taxonomy("location", "Location", "Locations", "product", [], $args = [
            'show_ui' => true,
            'query_var' => true,
            'show_admin_column' => true,
        ]);

        $building = new \Blue2\Common\Taxonomy("building", "Building", "Buildings", "product", [], $args = [
            'show_ui' => true,
            'query_var' => true,
            'show_admin_column' => true,
        ]);

        $capacity = new \Blue2\Common\Taxonomy("capacity", "Capacity", "Room Capacity", "product", [], $args = [
            'show_ui' => true,
            'query_var' => true,
            'show_admin_column' => true,
        ]);
    }

}
