<?php
$title = get_sub_field('title');
$services = get_sub_field('services');
$defaultImage = \Blue2\Scruffy\Site::getDefaultImage();

if($services) {

    $serviceCount = 0;

    ?>
    <section class="custom-flexible-section services-section">
        <div class="contain">
            <?php if($title) { ?><h2 class="text-center fw-500"><?= $title; ?></h2><?php } ?>
            <div class="services">
                <?php

                foreach($services as $service) {
                    $serviceCount++;
                    $titleType = $service['services_title_type'];

                    if ($serviceCount % 2 == 0) {
                        $primaryCol = 'order-2 offset-lg-1 col-lg-6';
                        $secondaryCol = 'image-col order-1 offset-md-2 col-md-8 offset-lg-0 col-lg-5';
                    } else {
                        $primaryCol = 'order-2 order-lg-1 col-lg-6';
                        $secondaryCol = 'image-col order-1 offset-md-2 col-md-8 offset-lg-0 order-lg-2 offset-lg-1 col-lg-5';
                    }

                    ?>
                    <div class="service-item <?= 'color-' . $service['colour']; ?>">

                        <div class="row row-eq-height">
                            <div class="<?= $primaryCol; ?> d-flex align-items-center">
                                <div class="content-wrapper">
                                    <?php if($service['title_image'] || $service['title_text']) { ?>
                                        <?php if($titleType == 'text') { ?>
                                            <h3 class="title-text"><?= $service['title_text']; ?></h3>
                                        <?php } else { ?>
                                            <img src="<?= $service['title_image']['url']; ?>" alt="<?= $service['title_image']['alt']; ?>" class="title-image">
                                        <?php } ?>

                                        <div class="description"><?= $service['description']; ?></div>

                                        <?php if($service['link']) { ?>
                                            <a href="<?= $service['link']['url']; ?>" class="cta u-case fw-700"><?= $service['link']['title']; ?></a>
                                        <?php } ?>
                                    <?php } ?>
                                </div>
                            </div>
                            <div class="<?= $secondaryCol; ?>">
                                <?php
                                if($service['service_image']){
                                    $imageDetails = wp_get_attachment_image_src($service['service_image']['id'], '');
                                    $image = '<img src=" ' . $imageDetails[0] . '" alt="'. $service['service_image']['alt'] .'">';
                                    $imageClass = 'featured-image';
                                } else {
                                    $image = $defaultImage;
                                    $imageClass = 'default-image';
                                }
                                ?>
                                <div class="image-wrapper <?= $imageClass; ?>">
                                    <?= $image; ?>
                                </div>
                            </div>
                        </div>


                    </div>
                <?php } ?>
            </div>
        </div>
    </section>
<?php } ?>
