<?php
namespace Blue2\Scruffy;

class Site extends \Blue2\Common\Site
{
    public function __construct()
    {
        parent::__construct();


        add_theme_support('post-thumbnails');
        add_action('after_setup_theme', [$this, 'registerMenus']);
        add_filter('excerpt_more', [$this, 'tidyExcerpt']);
        add_action('init', [$this, 'customImageSizes']);

        $this->registerShortCodes();
        $this->registerFilters();
        $this->registerActions();
        $this->setupControllers();
    }

    public function registerMenus()
    {
        register_nav_menus([
            'main_menu' => 'Main Menu',
            'footer_menu' => 'Footer Menu',
            'footer_the_circle' => 'Footer "The Circle" Menu',
            'footer_our_spaces' => 'Footer "Our Spaces" Menu',
            'footer_contact_us' => 'Footer "Contact Us" Menu',
        ]);
    }

    public function tidyExcerpt()
    {
        return '...';
    }

    private function registerShortCodes()
    {
        // Empty
    }

    private function registerFilters(){
        // Empty
    }

    private function registerActions() {
        add_action('init', [$this, 'registerPostTypes']);
    }

    private function setupControllers(){
        //Empty
    }

    public function registerPostTypes()
    {
        Post\Event::registerPostType();
    }

    public function customImageSizes()
    {
        add_image_size('2-wide', 761, 381, true);
        add_image_size('3-wide', 490, 245, true);
        add_image_size('4-wide', 355, 177, true);
        add_image_size('service-image', 628, 628, true);
    }

        public static function getDefaultImage() {
        $path = get_template_directory() . '/dist/images/the-circle-logo-white.svg';
        $file = file_get_contents($path);
        // remove xml header
        $file = str_replace(
            '<?xml version="1.0" encoding="UTF-8"?>',
            '',
            $file
        );
        // add class and attributes for accessibility
        return str_replace(
            '<svg',
            '<svg class="default-logo" role="img" aria-label="The Circle"',
            $file
        );
    }

}
