<?php

/**
 * Fired during plugin deactivation
 *
 * @link       https://blue2.co.uk
 * @since      1.0.0
 *
 * @package    Blue2_Monitor
 * @subpackage Blue2_Monitor/includes
 */

/**
 * Fired during plugin deactivation.
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @since      1.0.0
 * @package    Blue2_Monitor
 * @subpackage Blue2_Monitor/includes
 * @author     Blue2 Digital Ltd <ross@blue2.co.uk>
 */
class Blue2_Monitor_Deactivator
{

	/**
	 * Clear the scheduled event when the plugin is deactivated.
	 *
	 * @since    1.0.0
	 */
	public static function deactivate()
	{
		if (wp_next_scheduled('blue2_monitor_ping_server')) {
			$timestamp = wp_next_scheduled('blue2_monitor_ping_server');
			wp_unschedule_event($timestamp, 'blue2_monitor_ping_server');
		}
	}
}
