<?php

/**
 * Fired during plugin activation
 *
 * @link       https://blue2.co.uk
 * @since      1.0.0
 *
 * @package    Blue2_Monitor
 * @subpackage Blue2_Monitor/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Blue2_Monitor
 * @subpackage Blue2_Monitor/includes
 * @author     Blue2 Digital Ltd <ross@blue2.co.uk>
 */
class Blue2_Monitor_Activator
{

	/**
	 * When this plugin is activated, schedule a daily event to ping the server.
	 *
	 * @since    1.0.0
	 */
	public static function activate()
	{
		if (!wp_next_scheduled('blue2_monitor_ping_server')) {
			$tomorrow = strtotime('tomorrow 01:00');
			wp_schedule_event($tomorrow, 'daily', 'blue2_monitor_ping_server');
		}
	}
}
