<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://blue2.co.uk
 * @since             1.0.0
 * @package           Blue2_Monitor
 *
 * @wordpress-plugin
 * Plugin Name:       Blue2 Monitor
 * Plugin URI:        https://bitbucket.org.uk/blue2digital/site-monitor-plugin
 * Description:       This is the plugin for the Blue2 Site Monitor. It pings the server once a day with a breakdown of the site's plugin, PHP & Wordpress statuses.
 * Version:           1.0.0
 * Author:            Blue2 Digital Ltd
 * Author URI:        https://blue2.co.uk/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       blue2-monitor
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define('BLUE2_MONITOR_VERSION', '1.0.0');

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-blue2-monitor-activator.php
 */
function activate_blue2_monitor()
{
	require_once plugin_dir_path(__FILE__) . 'includes/class-blue2-monitor-activator.php';
	Blue2_Monitor_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-blue2-monitor-deactivator.php
 */
function deactivate_blue2_monitor()
{
	require_once plugin_dir_path(__FILE__) . 'includes/class-blue2-monitor-deactivator.php';
	Blue2_Monitor_Deactivator::deactivate();
}

register_activation_hook(__FILE__, 'activate_blue2_monitor');
register_deactivation_hook(__FILE__, 'deactivate_blue2_monitor');

/**
 * The core plugin class that is used to define internationalization,
 * and admin-specific hooks.
 */
require plugin_dir_path(__FILE__) . 'includes/class-blue2-monitor.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_blue2_monitor()
{
	$plugin = new Blue2_Monitor();
	$plugin->run();
}
run_blue2_monitor();
