<?php

/**
 * Provide an admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://blue2.co.uk
 * @since      1.0.0
 *
 * @package    Blue2_Monitor
 * @subpackage Blue2_Monitor/admin/partials
 */

$showMessage = false;
$messageColour = 'text-green-500';

if (isset($_SESSION['b2_monitor_response'])) {
    $response = $_SESSION['b2_monitor_response'];

    if ($response['success'] === false) {
        $messageColour = 'text-red-500';
    }

    $showMessage = $response['message'];
    unset($_SESSION['b2_monitor_response']);
}
?>

<div class="-ml-5 min-h-screen" id="blue2-monitor">
    <div class="bg-white border-b border-gray-100">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between h-16">
                <div class="shrink-0 flex items-center">
                    <svg class="block h-6 w-auto" role="img" aria-label="Blue2" aria-hidden="false" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 357.9 120.5">
                        <path d="M298.7 104.8v-7c.8-14.7 13.7-21.1 27.3-27.8 15.4-7.6 31.2-15.4 31.2-35.8 0-10-2.9-18-8.6-23.7C341.7 3.6 330.8.1 316.2.1h-.1c-12.2 0-24.2 2.5-32.1 4.7l-1 .3 3.2 13.5 1.1-.3c11.4-2.7 19.5-3.8 27.9-3.8 9.1.1 15.5 1.9 19.4 5.8 3.2 3.2 4.8 7.9 4.8 13.9 0 10.3-10.3 15.1-22.3 20.7-16 7.5-35.9 16.7-36.2 43.3v21.1h77v-14.5h-59.2z" fill="#00a0dd" />
                        <path d="M44.6 32.9c-12.3 0-22.3 5.4-30.6 16.4V7.1c0-4-3.1-7.1-7.1-7.1C3 0 0 3.1 0 7.1v105.2c0 3.9 3.2 7.1 7.1 7.1 3.9 0 6.9-3.1 6.9-7.1v-7.6c8 10.4 18.2 15.6 30.6 15.6 19.5 0 40.1-15.3 40.1-43.6v-.3c0-28.3-20.6-43.5-40.1-43.5zm25.8 43.6v.3c0 18.1-11.5 30.7-28 30.7-14.2 0-28.8-11.5-28.8-30.9v-.3c0-14.8 11-30.7 28.8-30.7 16.2 0 28 13 28 30.9zM98.9 0C95.1 0 92 3.2 92 7.1v105.2c0 4 3.1 7.1 7.1 7.1 4 0 6.9-3.1 6.9-7.1V7.1c0-3.9-3.2-7.1-7.1-7.1zM182 33.8c-4 0-6.9 3-6.9 7.1v41.6c0 14.6-9.8 24.8-23.7 24.8-13.7 0-21.8-8.9-21.8-23.9V40.9c0-3.9-3.2-7.1-7.1-7.1-4 0-6.9 3-6.9 7.1v45.6c0 20.5 12.7 33.8 32.4 33.8 11.5 0 20.5-4.6 27.2-14v5.9c0 4 3 7.1 6.9 7.1 3.9 0 6.9-3.1 6.9-7.1V40.9c0-3.9-3.1-7.1-7-7.1zm93.4 41.6c0-21.1-13.4-42.5-39-42.5-22.6 0-40.3 19.2-40.3 43.6v.3c0 24.9 18 43.6 41.9 43.6 12.7 0 22.5-3.9 31.6-12.6 1.4-1.2 2.2-2.9 2.2-4.6 0-3.4-2.8-6.1-6.3-6.1-1.9 0-3.2.9-4.1 1.7-6.8 6.3-14.3 9.3-23.1 9.3-14.9 0-26-10.4-27.9-26h58.4c3.6-.1 6.6-3 6.6-6.7zm-14.1-4.2h-50.9c1.9-15.5 12.4-26.2 25.7-26.2 16.5 0 23.8 13.3 25.2 26.2z" fill="#1b3668" />
                    </svg>
                </div>
                <a href="#" class="inline-flex items-center px-1 pt-1 border-b-2 border-transparent text-sm font-medium leading-5 text-gray-500 hover:text-gray-700 hover:border-gray-300 focus:outline-none focus:text-gray-700 focus:border-gray-300 transition duration-150 ease-in-out">Go To Site Monitor</a>
            </div>
        </div>
    </div>
    <main>
        <div class="max-w-7xl mx-auto py-10 sm:px-6 lg:px-8">
            <div class="md:grid md:grid-cols-3 md:gap-6">
                <div class="md:col-span-1 flex justify-between">
                    <div class="px-4 sm:px-0">
                        <h3 class="text-lg font-medium text-gray-900">API Token</h3>
                        <p class="mt-1 text-sm text-gray-600">
                            You need to create the site on the main Site Monitor to obtain the API Token required.
                        </p>
                    </div>
                </div>
                <div class="mt-5 md:mt-0 md:col-span-2">
                    <form action="<?= esc_url(admin_url('admin-post.php')) ?>" method="post">
                        <input type="hidden" name="action" value="b2_monitor_save_api_token">
                        <input type="hidden" name="_wpnonce" value="<?= wp_create_nonce('b2_monitor_save_api_token') ?>">
                        <div class="px-4 py-5 bg-white sm:p-6 shadow sm:rounded-tl-md sm:rounded-tr-md">
                            <div class="grid grid-cols-6 gap-6">
                                <div class="col-span-6 sm:col-span-4">
                                    <label class="block font-medium text-sm text-gray-700" for="api_token">API Token</label>
                                    <input type="text" name="api_token" class="border-gray-300 focus:border-blue-500 focus:ring-blue-500 rounded-md shadow-sm mt-1 block w-full" value="<?= get_option('b2_monitor_api_token', '') ?>">
                                </div>
                            </div>
                        </div>
                        <div class="flex items-center justify-between px-4 py-3 bg-gray-50 text-end sm:px-6 shadow sm:rounded-bl-md sm:rounded-br-md">
                            <div class="<?= $messageColour ?>">
                                <?php if ($showMessage) {
                                    echo $showMessage;
                                } ?>
                            </div>
                            <button type="submit" class="inline-flex items-center px-4 py-2 bg-gray-800 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-gray-700 focus:bg-gray-700 active:bg-gray-900 focus:outline-none focus:ring-2 focus:ring-blue-800 focus:ring-offset-2 transition ease-in-out duration-150">
                                Save
                            </button>
                        </div>
                    </form>
                </div>
            </div>
            <div class="hidden sm:block">
                <div class="py-8">
                    <div class="border-t border-gray-200"></div>
                </div>
            </div>
            <div class="md:grid md:grid-cols-3 md:gap-6">
                <div class="md:col-span-1 flex justify-between">
                    <div class="px-4 sm:px-0">
                        <h3 class="text-lg font-medium text-gray-900">Send Ping to Server</h3>
                    </div>
                </div>
                <div class="mt-5 md:mt-0 md:col-span-2">
                    <div class="relative px-4 py-5 sm:p-6 bg-white shadow sm:rounded-lg">
                        <?php if (get_option('b2_monitor_api_token')) { ?>
                            <div class="max-w-xl text-sm text-gray-600">If this is your first time installing the plugin or if there hasn't been a ping recently, use this button to manually send a ping to the Site Monitor.</div>
                            <div class="flex items-center mt-4 gap-4">
                                <button type="button" id="ping_server" class="inline-flex items-center px-4 py-2 bg-gray-800 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-gray-700 focus:bg-gray-700 active:bg-gray-900 focus:outline-none focus:ring-2 focus:ring-blue-800 focus:ring-offset-2 transition ease-in-out duration-150">
                                    Ping Server
                                </button>
                                <div id="ping_server-response"></div>
                            </div>
                            <div role="status" class="absolute inset-0 hidden" id="ping_server-loader">
                                <div class="absolute inset-0 bg-gray-100 opacity-50"></div>
                                <div class="absolute -translate-x-1/2 -translate-y-1/2 top-2/4 left-1/2">
                                    <svg aria-hidden="true" class="w-8 h-8 text-gray-300 animate-spin dark:text-gray-600 fill-blue-600" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor" />
                                        <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill" />
                                    </svg>
                                    <span class="sr-only">Loading...</span>
                                </div>
                            </div>
                        <?php } else { ?>
                            <div class="max-w-xl text-sm text-gray-600">You need to enter your API Token before you can send a ping to the server.</div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </main>
</div>
