(function ($) {
	'use strict';

	$(window).load(function () {
		$('#ping_server').click(function (e) {
			e.preventDefault();

			$('#ping_server-loader').removeClass('hidden');
			$('#ping_server-response').empty();

			$.ajax({
				type: "POST",
				dataType: "json",
				url: ajaxurl,
				data: {
					action: 'blue2_monitor_ping_server'
				},
				success: function (response) {
					if (response.success) {
						$('#ping_server-response').append('<p class="text-green-500">' + response.data + '</p>');
					} else {
						$('#ping_server-response').append('<p class="text-red-500">' + response.data + '</p>');
					}
				},
				error: function () {

				},
				complete: function () {
					$('#ping_server-loader').addClass('hidden');
				}
			});
		});
	});

})(jQuery);
