<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://blue2.co.uk
 * @since      1.0.0
 *
 * @package    Blue2_Monitor
 * @subpackage Blue2_Monitor/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Blue2_Monitor
 * @subpackage Blue2_Monitor/admin
 * @author     Blue2 Digital Ltd <ross@blue2.co.uk>
 */
class Blue2_Monitor_Admin
{
	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct($plugin_name, $version)
	{
		$this->plugin_name = $plugin_name;
		$this->version = $version;
	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 * @return void
	 */
	public function enqueue_styles(): void
	{
		if (get_current_screen()->id === 'settings_page_blue2-monitor') {
			wp_enqueue_style($this->plugin_name, plugin_dir_url(__FILE__) . 'css/blue2-monitor-admin.css', array(), $this->version, 'all');
		}
	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 * @return void
	 */
	public function enqueue_scripts(): void
	{
		wp_enqueue_script($this->plugin_name, plugin_dir_url(__FILE__) . 'js/blue2-monitor-admin.js', array('jquery'), $this->version, false);
	}

	/**
	 * Add the plugin to the settings menu.
	 *
	 * @since 1.0.0
	 * @return void
	 */
	public function settings_menu(): void
	{
		$title = __('Blue2 Monitor', 'blue2-monitor');

		add_submenu_page('options-general.php', $title, $title, 'manage_options', 'blue2-monitor', array($this, 'settings_page'));
	}

	/**
	 * Load the template for the settings page.
	 *
	 * @since 1.0.0
	 * @return void
	 */
	public function settings_page(): void
	{
		include_once plugin_dir_path(__FILE__) . 'partials/blue2-monitor-admin-display.php';
	}

	/**
	 * Add a link to the plugin's settings on the plugins page.
	 *
	 * @since 1.0.0
	 * @param array $links
	 * @return array
	 */
	public function add_action_links(array $links): array
	{
		$settingLinks = [
			'<a href="' . admin_url('options-general.php?page=blue2-monitor') . '">' . __('Settings', 'blue2-monitor') . '</a>',
		];

		return array_merge($settingLinks, $links);
	}
}
