<div class="contact-us">
    <div id="map"></div>

    <div class="contact-container">    
        <div class="contact-content">
            <?php echo B2\Scruffy\Site::getTitle('<h1>', '</h1>'); ?>
            <?php the_content() ?>
        </div>
    </div>

    <div class="content-container">
        <div class="row">
            <div class="col-md-8">
                <?= get_field('contact_form') ?  do_shortcode( get_field('contact_form')) : ''; ?>
            </div>
            <div class="col-md-4">
                <?php
                    if( have_rows('contacts') ){ ?>
                        <h2 id="contact-head"><?php the_field('contact_heading'); ?></h2>
                        <?php while ( have_rows('contacts') ) : the_row(); ?>
                            <div class="keycontact">
                                <p><strong><?php the_sub_field('name'); ?></strong><span> <?php the_sub_field('position'); ?></span></p>

                                <?php if(get_sub_field('phone')){ ?>
                                    <p><strong>Tel: </strong><a href="tel:<?php echo str_replace(' ', '', get_sub_field('phone')); ?>"><?php the_sub_field('phone'); ?></a></p>
                                <?php } ?>

                                <?php if(get_sub_field('email')){ ?>
                                    <p><strong>Email: </strong><a href="mailto:<?php the_sub_field('email'); ?>?subject=Website Enquiry"><?php the_sub_field('email'); ?></a></p>
                                <?php } ?>

                                <?php if(get_sub_field('linkedin')){ ?>
                                    <p><strong>LinkedIn: </strong><a href="<?php the_sub_field('linkedin'); ?>" target="_blank">View here</a></p>
                                <?php } ?>

                                <?php if(get_sub_field('areas')){ ?>
                                    <p><strong>Areas: </strong><a href=""><?php the_sub_field('areas'); ?></a></p>
                                <?php } ?>
                                
                            </div>
                        <?php endwhile;
                    }
                ?>
            </div>
        </div>
    </div>
</div>

<?php
$location = get_field('map');
?>
<script type="text/javascript">

    function initMap() {
        
        var map = new google.maps.Map(document.getElementById('map'), {
            zoom: 17,
            center: new google.maps.LatLng(<?= $location['lat'] ?>,<?= $location['lng'] ?>),
            mapTypeId: google.maps.MapTypeId.ROADMAP,
            disableDefaultUI: true,
            gestureHandling: 'none',
            clickableIcons: false,
            styles: [{
            featureType: 'poi.business',
            stylers: [{visibility: 'off'}]
          }],
        });

        var infowindow = new google.maps.InfoWindow();

        var marker;

            var myLatLng = new google.maps.LatLng(<?= $location['lat'] ?>,<?= $location['lng'] ?>);

            marker = new google.maps.Marker({
                position: myLatLng,
                map: map,
                title: 'Sekers Fabrics Ltd'
            });

        }    
</script>

<script async defer src="https://maps.googleapis.com/maps/api/js?key=<?php echo B2\SekersSite::GOOGLE_API_KEY; ?>&callback=initMap"></script>
