var webpack = require('webpack');

// This is used to clean the dist folder at the start of the build
var CleanWebpackPlugin = require('clean-webpack-plugin');

// This is used ot pull CSS into it's own file
var ExtractTextPlugin = require("extract-text-webpack-plugin");

// This is used to copy image files from source to dist)
var CopyWebpackPlugin = require('copy-webpack-plugin');

// This is used to optimise those images while they are copying
var ImageminPlugin = require('imagemin-webpack-plugin').default;
var imageminMozjpeg = require('imagemin-mozjpeg');

// This is used to auto-reload browsers
var BrowserSyncPlugin = require('browser-sync-webpack-plugin');

module.exports = function (env) {

    var entry = [
        "./assets/scripts/app.js", "./assets/styles/main.less", "./assets/styles/main.scss"
    ];

    var distPath = __dirname + "/../dist";

    var devUrl = 'sekers.local';

    return {
        entry: entry,
        output: {
            path: distPath,
            publicPath: "./",
            filename: "site.js"
        },
        module: {
            rules: [
                {
                    test: /\.(less)$/,
                    use: ExtractTextPlugin.extract({
                        fallback: "style-loader",
                        use: [
                            {
                                loader: 'css-loader', // translates CSS into CommonJS modules
                            },
                            {
                                loader: 'postcss-loader', // Run post css actions
                            },      
                            //'resolve-url-loader',
                            {
                                loader: 'less-loader', // compiles LESS to CSS
                            }
                        ]
                    })
                },
                {
                    test: /\.(scss)$/,
                    use: ExtractTextPlugin.extract({
                        fallback: "style-loader",
                        use: [
                            {
                                loader: 'css-loader', // translates CSS into CommonJS modules
                                options: {
                                  sourceMap: true
                              }
                            },
                            {
                                loader: 'postcss-loader', // Run post css actions
                                options: {
                                  sourceMap: true
                              }
                            },      'resolve-url-loader',
                            {
                                loader: 'sass-loader', // compiles SASS to CSS
                                options: {
                                  sourceMap: true
                              }
                            }
                        ]
                    })
                },
                {
                    test: /\.(eot|svg|ttf|woff|woff2)$/,
                    use: [                        {
                        loader: 'file-loader?name=fonts/[name].[ext]'}

                    ]
                },
                {
                    test: /\.(jpe?g|png|gif)$/,
                    use: [{
                        loader: 'file-loader',
                        options: {
                            name:'[name].[ext]',
                          emitFile: false,
                          useRelativePath: true
                        }}

                    ]
                }
            ]
        },
        devtool: 'source-map',
        externals: {
            jquery: 'jQuery',
        },
        plugins: [
            new CleanWebpackPlugin([distPath], {verbose: true, allowExternal: true}),
            new ExtractTextPlugin("site.css"),
            new CopyWebpackPlugin([
                { from: 'assets/images/', to: 'images' }
            ]),
            new ImageminPlugin({ 
/*
                test: /\.(jpe?g|png|gif|svg)$/i,
                optipng: { optimizationLevel: 7 },
                gifsicle: { optimizationLevel: 3 },
                pngquant: { quality: '65-90', speed: 4 },
                svgo: { removeUnknownsAndDefaults: false, cleanupIDs: false },
                plugins: [imageminMozjpeg({ quality: 75 })]
*/
            }),
            new webpack.ProvidePlugin({
                $: 'jquery',
                jQuery: 'jquery',
                'window.jQuery': 'jquery',
                Popper: ['popper.js', 'default'],
            }),
            new BrowserSyncPlugin({
                proxy: devUrl
            })
        ]
    }
}