<?php

/**
 * Cart Page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.1.0
 */

if (!defined('ABSPATH')) {
	exit;
}

wc_print_notices();
?>

<div class="row">
	
<?php

$basket_copy = get_field('basket_copy');

if($basket_copy){


	echo '<div class="col-md-6">';
	echo apply_filters('the_content', $basket_copy);
	echo '</div><div class="col-md-6">';

}
else{
	echo '<div class="col-12">';
}

do_action('woocommerce_before_cart'); ?>

<form class="woocommerce-cart-form" action="<?php echo esc_url(wc_get_cart_url()); ?>" method="post">

	<?php
foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {
	$_product = apply_filters('woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key);
	$product_id = apply_filters('woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key);

	if ($_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters('woocommerce_cart_item_visible', true, $cart_item, $cart_item_key)) {
		$product_permalink = apply_filters('woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink($cart_item) : '', $cart_item, $cart_item_key);
		?>
					<div class="cart-product <?php echo esc_attr(apply_filters('woocommerce_cart_item_class', 'cart_item', $cart_item, $cart_item_key)); ?>">


					<h3 class="cart-product-title">
					<?php
				$cat_name = B2\SekersSiteWooCustom::getProductCatName($_product);
				if (!$product_permalink) {
					echo apply_filters('woocommerce_cart_item_name', $cat_name . $_product->get_name(), $cart_item, $cart_item_key) . '&nbsp;';
				} else {
					echo apply_filters('woocommerce_cart_item_name', sprintf('<a href="%s">%s</a>', esc_url($product_permalink), $cat_name . $_product->get_name()), $cart_item, $cart_item_key);
				}
				?>
					</h3>
<div class="cart-product-image">

<?php
$thumbnail = apply_filters('woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key);

if (!$product_permalink) {
	echo $thumbnail;
} else {
	printf('<a href="%s">%s</a>', esc_url($product_permalink), $thumbnail);
}
?>
</div>
							<div class="cart-product-info">

							<?php
        $parent_id = $_product->get_parent_id();
        $parent = get_post($parent_id);
						echo apply_filters('the_content', $parent->post_content);

								// Meta data
						echo WC()->cart->get_item_data($cart_item);

								// Backorder notification
						if ($_product->backorders_require_notification() && $_product->is_on_backorder($cart_item['quantity'])) {
							echo '<p class="backorder_notification">' . esc_html__('Available on backorder', 'woocommerce') . '</p>';
						}
						?>
							<div>
							Quantity: 
														<?php
													if ($_product->is_sold_individually()) {
														$product_quantity = sprintf('1 <input type="hidden" name="cart[%s][qty]" value="1" />', $cart_item_key);
													} else {
														$product_quantity = woocommerce_quantity_input(array(
															'input_name' => "cart[{$cart_item_key}][qty]",
															'input_value' => $cart_item['quantity'],
															'max_value' => $_product->get_max_purchase_quantity(),
															'min_value' => '0',
														), $_product, false);
													}

													echo apply_filters('woocommerce_cart_item_quantity', $product_quantity, $cart_item_key, $cart_item);
													?>
							</div>
							<?php
						echo apply_filters('woocommerce_cart_item_remove_link', sprintf(
							'<a href="%s" class="remove" aria-label="%s" data-product_id="%s" data-product_sku="%s"><i class="fas fa-minus-circle"></i> Remove item</a>',
							esc_url(WC()->cart->get_remove_url($cart_item_key)),
							__('Remove this item', 'woocommerce'),
							esc_attr($product_id),
							esc_attr($_product->get_sku())
						), $cart_item_key);
						?>
						<?php do_action( 'woocommerce_cart_contents' ); ?>
						<?php do_action( 'woocommerce_cart_actions' ); ?>
						<?php wp_nonce_field( 'woocommerce-cart' ); ?>
						</div>
					</div>
					<?php
			}
		}
		?>
		<input style="display:none" type="submit" class="button" name="update_cart" value="<?php esc_attr_e('Update cart', 'woocommerce'); ?>" />
			
</form>

<div class="cart-collaterals cart-collaterals-inline">
	<?php

/**
 * woocommerce_cart_collaterals hook.
 *
 * @hooked woocommerce_cross_sell_display
 * @hooked woocommerce_cart_totals - 10
 */
do_action('woocommerce_cart_collaterals');
?>
</div>

<?php do_action('woocommerce_after_cart'); ?>
</div>
</div>