<?php
$url = is_archive() ? null : get_permalink( wc_get_page_id( 'shop' ) );
$collectionPage = is_tax('product_cat');
?>
<form id="product-filter-form" method="post" action="<?= $url ?>">
    <div class="search-bar">
        <ul class="product-search">
            <?php if (have_rows('featured_collections', 'options')) { ?>
                <li>Latest
                    <div class="filter-panel" style="display:none">
                        <?php while (have_rows('featured_collections', 'options')) {
                            the_row();

                            $featuredId = get_sub_field('collection');
                            $featured = get_term($featuredId);
                            ?>
                            <a href="<?php echo get_term_link($featured); ?>"><?php echo $featured->name; ?></a>
                            <?php
                        } ?>
                    </div>
                </li>
            <?php } ?>
            <li>Collections
                <div class="filter-panel filter-panel-collections" style="display:none">
                    <div class="col">
                        <?php


                        $args = array(
                            'taxonomy' => 'product_cat',
                            'hide_empty' => false,
                        );


                        $collections = get_terms( $args );
                        $counter = 0;

                        foreach($collections as $collection){

                            $isFroneCollect = get_field('is_frone','term_' . $collection->term_id);
                            if (!($isFroneCollect == true)) {

                                $display = $counter > 15 ? 'style="display:none"' : '';
                                ?>
                                <a <?php echo $display ?> href="<?php echo get_term_link($collection); ?>"><?php echo $collection->name; ?></a>
                                <?php
                                $counter++;

                            }
                        }
                        ?>
                        <a class="show-more" href='#'><i class="fal fa-plus"></i> Show More</a>
                    </div>
                </div></li>

            <?php

            /*
            Collection

            Design

            Product Type

            Pattern

            Fabric Type

            Colours

            Performance*/

            $performance = [];
            $ids = $collectionPage ? \B2\SekersSiteWooCustom::getCollectionMemberIds($performance) : false;


            if(!$collectionPage){

                $field_key = "field_5a858b66bf614";
                $field = get_field_object($field_key);
                if( $field )
                {
                    echo B2\Scruffy\Site::renderFilter('Product Type', 'product_type', $field['choices']);
                }
            }

            $designs = get_terms(['taxonomy' => 'designs', 'hide_empty' => false, 'object_ids' => $ids]);
            echo B2\Scruffy\Site::renderFilter('Pattern', 'design', $designs, true);

            $fabrics = get_terms(['taxonomy' => 'fabric_types', 'hide_empty' => false, 'object_ids' => $ids]);
            echo B2\Scruffy\Site::renderFilter('Fabric Type', 'fabric', $fabrics);

            $colours = get_terms(['taxonomy' => 'colour', 'hide_empty' => false, 'object_ids' => $ids]);
            echo B2\Scruffy\Site::renderFilter('Colours', 'p_colour', $colours, false, 'filter-panel-colour');

            $field_key = "field_5a858bb3bf617";
            $field = get_field_object($field_key);
            if( $field )
            {
                $choices = $field['choices'];

                if($collectionPage){
                    foreach($choices as $key => $choice){
                        if(!in_array($key, $performance)){
                            unset($choices[$key]);
                        }
                    }
                }

                echo B2\Scruffy\Site::renderFilter('Performance', 'performance', $choices);
            }

            $usages = get_terms(['taxonomy' => 'usages', 'hide_empty' => false, 'object_ids' => $ids]);
            echo B2\Scruffy\Site::renderFilter('Usage', 'usage', $usages, true);
            ?>
        </ul>
        <input type="hidden" id="filter" name="filter" value="1" />
        <input type="hidden" id="page" name="page" value="0" />
</form>
</div>
