<?php
namespace B2\Scruffy;

class Utils
{
    public static function simpleWrappedLoop($contentSlug = "", $headerName = "", $footerName = "") 
    {
        get_header( $headerName );
        self::simpleLoop( $contentSlug );
        get_footer( $footerName );
    }
    
    public static function simpleWrapped($templateSlug = "", $headerName = "", $footerName = "") 
    {
        get_header( $headerName );
        locate_template( 'templates/'.$templateSlug.'.php', true );
        get_footer( $footerName );
    }
    
    public static function simpleLoop($contentSlug = "") 
    {
        if (have_posts()) {
            while (have_posts()) {
                the_post();
                self::includeContentTemplate($contentSlug);
            }
        } else {
            get_template_part( 'templates/content', 'none' );
        }
    }

    public static function includeContentTemplate($contentSlug = "")
    {
        $post = get_post();

        $templates = array(
            'templates/content-' . $contentSlug . '.php',
            'templates/content-' . $post->post_name . '.php',
            'templates/content-' . get_post_type() . '.php',
            'templates/content-' . get_post_format() . '.php',
            'templates/content.php'
        );

        locate_template( $templates, true );
    }
}