<?php
namespace B2\Scruffy;

class Site
{

    public function __construct()
    {
        add_action('after_setup_theme', array($this, 'addThemeSupport'));
        add_action('after_setup_theme', array($this, 'registerMenus'));
        add_filter('excerpt_more', array($this, 'tidyExcerpt'));
        add_action('wp_enqueue_scripts', array($this, 'enqueueAssets'), 100);

        $this->removeBloat();

        $themeSettings = new ThemeSettings();
        $themeSetup = new ThemeSetup();
        $pageMeta = new PageMeta();
    }

    public function addThemeSupport()
    {
        add_theme_support('title-tag');
        add_theme_support('post-thumbnails');

        // Enable HTML5 markup support
        // http://codex.wordpress.org/Function_Reference/add_theme_support#HTML5
        add_theme_support('html5', ['caption', 'comment-form', 'comment-list', 'gallery', 'search-form']);

        add_image_size('sekers-banner',1900, 800, true);
        add_image_size('sekers-banner--thin',1900, 450, true);
        add_image_size('sekers-large-image',745, 596, true);
        add_image_size('sekers-small-image-portrait',248, 298, true);
        add_image_size('sekers-small-image-wide',745, 298, true);
        add_image_size('sekers-small-image',370, 300, true);

        // Soil theme support
        add_theme_support('soil-clean-up');
        add_theme_support('soil-nav-walker');
        add_theme_support('soil-nice-search');
        add_theme_support('soil-jquery-cdn');
        add_theme_support('soil-relative-urls');

        //Add Woocommerce support
        add_theme_support( 'woocommerce' );

    }

    public function registerMenus()
    {
        register_nav_menus(array(
            'main_menu' => 'Main Menu',
            'footer_menu' => 'Footer Menu',
            'fr-one_menu' => 'FR-One Menu'
        ));
    }

    public function tidyExcerpt()
    {
        return ' &hellip; <a href="' . get_permalink() . '">Continued</a>';
    }

    public function enqueueAssets()
    {
        wp_enqueue_style('b2/css', get_template_directory_uri() . '/dist/site.css', false, null);
        wp_enqueue_script('b2/js', get_template_directory_uri() . '/dist/site.js', ['jquery'], null, true);
    }

    public static function getTitle($prefix = "", $suffix = "")
    {
        $title = get_the_title();

        if (is_home()) {
            if (get_option('page_for_posts', true)) {
                $title = get_the_title(get_option('page_for_posts', true));
            } else {
                // it's a blog home page
                $title = 'Latest Posts';
            }
        } elseif (is_archive()) {
            $title = get_the_archive_title();
        } elseif (is_search()) {
            $title = sprintf('Search Results for %s', get_search_query());
        } elseif (is_404()) {
            $title = 'Not Found';
        }

        return $prefix . $title . $suffix;
    }

    public function removeBloat()
    {
        // Emoji support adds a load of bloat to the page... let's remove it
        remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
        remove_action( 'admin_print_scripts', 'print_emoji_detection_script' );
        remove_action( 'wp_print_styles', 'print_emoji_styles' );
        remove_action( 'admin_print_styles', 'print_emoji_styles' );
    }

    public static function renderFilter($label, $identifier, $options, $showIcons=false, $additionalClass='')
    {
        global $wp_query;
        $urlFilter = isset($wp_query->query_vars['sekers_coll_filter']) ? $wp_query->query_vars['sekers_coll_filter'] : null;
        ?>
			<li><?= $label?>
                <div class="filter-panel <?= $showIcons ? 'filter-panel-icon '.$additionalClass : $additionalClass?>" style="display:none">
                <?php
                $value = filter_input(INPUT_POST, $identifier);
                if(count($options)){
                    foreach($options as $slug => $option){

                        if(!is_string($option)){
                            $slug = $option->slug;
                            $option = $option->name;
                        }
                        if($urlFilter == $slug){
                            $value = $urlFilter;
                        }

                        $icon = $showIcons ? '<span class="icon icon-'.$slug.'"></span>' :'';

                        ?>
                        <a data-filtertype="<?= $identifier ?>" data-filter="<?= $slug; ?>" href="#" title="<?= $option ?>" class="filter filter-<?= $identifier ?> filter-<?= $identifier ?>-<?=$slug?> <?= filter_input(INPUT_POST, $identifier) ==  $slug || $urlFilter == $slug ? 'active' : ''; ?>"><?= $icon.$option; ?><i class="far fa-times"></i></a>
                        <?php
                    }
                }else{
                    echo '<span>No filters available</span>';
                }
                ?>
                </div>
                <input type="hidden" id="<?= $identifier ?>" name="<?= $identifier ?>" value="<?= $value ;?>"/>
            </li>
            <?php
    }
}