<div class="container-fluid">
    <div class="row pane-row pane-row--overlap">
        <div class="flexslider flexslider-collection flexslider-collection--home">
          <ul class="slides">

            <?php
            $launches = get_field('collection_launches');

            if(is_array($launches)){
              foreach($launches as $launch){

                  $launchTerm = get_term($launch['collection']);
                  $highlights = get_field('highlights', $launchTerm);

                  $thumbnail_id = get_woocommerce_term_meta( $launchTerm->term_id, 'thumbnail_id', true );
                  $image = wp_get_attachment_image( $thumbnail_id, 'sekers-banner' );
                  $imageSrc = wp_get_attachment_image_src( $thumbnail_id, 'sekers-banner' );
                ?>
              <li style="background-image: url('<?php echo $imageSrc[0]; ?>');">

              <?php echo $image; ?>
                <div class="container d-none">
                  <div class="row">
                    <div class='slide-info'>
                      <h1><span>The</span><br/><?php echo $launchTerm->name; ?> Collection</h1>
                        <p class="shaded-bg">
                           <span class="shaded-bg--angle"></span>
                           <?php echo $launchTerm->description; ?>
                        </p>
                        <a href="<?php echo get_term_link($launchTerm); ?>" class="btn btn-mauve">VIEW COLLECTION</a>
                        <a href="<?php echo get_permalink( wc_get_page_id( 'shop' ) ); ?>" class="slide-anchor">All collections</a>
                    </div>
                  </div>
                </div>

                <?php
                  if(is_array($highlights)){
                    foreach($highlights as $highlight){
                      $image = wp_get_attachment_image( $highlight['image']['ID'] );
                      ?>
                        <span class="highlight" style="top:<?= $highlight['vertical']; ?>%;left:<?= $highlight['horizontal']; ?>%;"><i class="fas fa-plus"></i><?= $image; ?></span>
                      <?php
                    }
                }
                ?>
              </li>
                <?php
              }
            }
            ?>
          </ul>
        </div>

        <div class="pane pane--dark pane__content top-panel">
           <div class="angle-me-container">
               <div class="angle-me"> </div>
           </div>
           <div class="slide-info pane__inner flexslider-captions flexslider-captions-collection flexslider-captions-collection--home">

           </div>
           <div class="flexslider-controls-container"> </div>
        </div>
        <div class="pane pane__side">

        </div>



    </div>



   <div class="row pane-row">
       <div class="pane pane__content">
           <div class="pane__inner pane__homesearch">
               <div class="explore-col">
                   <h2>Explore Our Fabrics</h2>
                    <?php get_template_part('templates/parts/search', 'bar'); ?>
                    <?php the_content(); ?>
                   <?php
                   if( have_rows('fabric_ctas') ){
                       while ( have_rows('fabric_ctas') ) : the_row(); ?>
                           <a href="<?php the_sub_field('link'); ?>" class="btn btn-olive-green"><?php the_sub_field('text'); ?></a>
                       <?php endwhile;
                   }
                   ?>
               </div>
           </div>
       </div>
       <div class="pane pane__side pane--infront col-lg">
           <div class="angle-me-container">
               <div class="angle-me angle-me-right">
                    <?php
                    $postImage_id = get_post_thumbnail_id();
                    $postImage = wp_get_attachment_image_src( $postImage_id, 'sekers-banner' );
                    $contentBg = $postImage ? 'style="background-image:url('.$postImage[0].')"' : '';
                    ?>
                   <img src="<?= $postImage[0] ?>"/>
               </div>
           </div>
       </div>
   </div>

   <div class="row pane-row fr-one-pane">
       <div class="pane pane__content fr-one">
            <img class="frone-image" src="<?= get_template_directory_uri() ?>/dist/images/FR-One.png"></img>
            <p><?= get_field('fr_text'); ?></p>
            <div class="fr-one-image">
              <?php
                if( have_rows('fr_images') ){
                    while ( have_rows('fr_images') ) {
                      the_row();
                      ?>
                      <img class="fr-images" src="<?= get_sub_field('fr_image') ?>"></img>
                      <?php
                    }
                }
              ?>
            </div>
            <div>
            <a href="/fr-one/" class="btn btn-mauve fr-but">VIEW ALL</a>
            <a href="" class="btn btn-mauve fr-but">ORDER A SAMPLE</a>
          </div>
       </div>
       <div class="pane pane__side pane--infront col-lg">
           <div class="angle-me-container">
               <div class="angle-me angle-me-right">
                    <?php
                    $postImage_id = get_post_thumbnail_id();
                    $postImage = wp_get_attachment_image_src( $postImage_id, 'sekers-banner' );
                    $contentBg = $postImage ? 'style="background-image:url('.$postImage[0].')"' : '';
                    ?>
                   <img src="<?= $postImage[0] ?>"/>
               </div>
           </div>
       </div>
   </div>


    <?php
      $postImage_id = get_field('split_image_1');
      $postImage = wp_get_attachment_image_src( $postImage_id, 'sekers-banner' );
      $contentBg = $postImage ? 'style="background-image:url('.$postImage[0].')"' : '';
    ?>

    <div class="row pane-row" <?php echo $contentBg; ?>>
               <div class="pane pane--dark pane__content dark col col-sm-12 col-lg-8 anti-microbial">
                   <div class="pane__inner">
                       <div class="tech-spec-col">
                        <h2><?php the_field('technical_header'); ?></h2>
                        <?php
                        $tech = get_field('technical_specification');
                        echo apply_filters('the_content', $tech);
                        if(get_field('technical_link')){ ?>
                           <a href="<?php the_field('technical_link'); ?>" class="btn btn-red-orange"><?php the_field('technical_text'); ?></a>
                        <?php } ?>
                      </div>
                   </div>
               </div>
               <div class="pane pane__side pane--infront col-md d-none d-lg-block">
                   <div class="angle-me-container">
                        <div class="angle-me angle-me-right">
                            <?php
                                $split_image_2 = get_field('split_image_2');
                                 echo wp_get_attachment_image( $split_image_2, 'sekers-banner' );
                            ?>
                        </div>
                   </div>
               </div>
    </div>

</div>
