<?php
$parentId = wp_get_post_parent_id(get_the_ID());
$parent = get_post($parentId);
?>

<div class="row">


<table class="table table-bordered table-product-info">
            <tr>
            <td colspan="2">Composition: <br/><span class="info"><?= get_field('composition', $parentId) ? get_field('composition', $parentId) : 'N/A'; ?></span></td>
            <td colspan="2">Roll Length:  <br/><span class="info"><?= get_field('roll_length', $parentId) ? get_field('roll_length', $parentId) : 'N/A'; ?> m</span></td>
            </tr>
            <tr>
            <td colspan="2">Weight:  <br/><span class="info"><?= get_field('weight', $parentId) ? get_field('weight', $parentId) : 'N/A'; ?> gms / sq mtr</span></td>
            <td colspan="2">Cleaning:  <br/><span class="info"> 
            <?php
            $careTags = get_field('washing_instructions', $parentId);
            $care = get_field('care', $parentId);
            if (($careTags && count($careTags)) || $care) {
                if (($careTags && count($careTags))) {
                    foreach ($careTags as $careTag) {
                        echo '<span class="icon icon-'.$careTag['value'].'" title="'.$careTag['label'].'"></span>';
                    }
                }
                
                if ($care) {
                    echo $care;
                }
            }?></span></td>
            </tr>

            <tr>
            <td>Martindale: <br/><span class="info"><?= get_field('martindale', $parentId) ? get_field('martindale', $parentId) : 'N/A'; ?></span></td>
            <td>Wyzenbeek:  <br/><span class="info"><?= get_field('wyzenbeek', $parentId) ? get_field('wyzenbeek', $parentId) : 'N/A'; ?> <br/>(Cotton Duck)</span></td>
            <td colspan="2">
                Usage: <br/><span class="info">
                <?php
                $usages = wp_get_post_terms($parentId, 'usages');
                if (count($usages)) {
                    foreach ($usages as $usage) {
                        echo '<span class="icon icon-'.$usage->slug.'" title="'.$usage->name.'"></span>';
                    }
                }
                    ?></span></td>
            </tr>

            <tr>
            <td colspan="2">Pilling: <br/><span class="info"><?= get_field('pilling', $parentId) ? get_field('pilling', $parentId) : 'N/A'; ?></span></td>
            <td colspan="2">Horizontal repeat:  <br/><span class="info"><?= get_field('repeat', $parentId) ? get_field('repeat', $parentId) : 'N/A'; ?> cm</span></td>
            </tr>
            <tr>
            <td colspan="2">Fabric Type: <br/><span class="info">
                <?php
                    $fabricTypes = wp_get_post_terms($parentId, 'fabric_types', array("fields" => "names"));
                    if (count($fabricTypes)) {
                        echo implode(', ', $fabricTypes);
                    } ?>
        </span></td>
            <td colspan="2">Vertical Repeat:  <br/><span class="info"><?= get_field('vertical_repeat', $parentId) ? get_field('vertical_repeat', $parentId) : 'N/A'; ?> cm</span></td>
            </tr>
            <tr>
            <td colspan="2">SqM per Roll: <br/><span class="info"><?= get_field('sqm_per_roll', $parentId) ? get_field('sqm_per_roll', $parentId) : 'N/A'; ?></span></td>
            <td colspan="2">Match:  <br/><span class="info"><?= get_field('match', $parentId) ? get_field('match', $parentId) : 'N/A'; ?></span></td>
            </tr>
        </table>

        <?php
/*
        <ul class="product-info">
            <?php
            $fabricTypes = wp_get_post_terms($parentId, 'fabric_types', array("fields" => "names"));
            if(count($fabricTypes)) { ?>
                <li><span class="label">fabric type:</span> <?php echo implode(', ', $fabricTypes); ?></li>
            <?php } ?>
        </ul>
        <ul class="product-info">
            <?php if(get_field('width', $parentId)) { ?>
                <li><span class="label">width (cm):</span> <?= get_field('width', $parentId); ?></li>
            <?php } ?>
            <?php
            $designs = wp_get_post_terms($parentId, 'designs');
            if(count($designs)) { ?>
                <li><span class="label">design:</span> <?php
                foreach($designs as $design){
                    echo '<span class="icon icon-'.$design->slug.'" title="'.$design->name.'"></span>';
                }
                ?>
            </li>
            <?php } ?>
        </ul>

        */ ?>

        <table class="table table-borderless">
            <thead><tr><th colspan="2">Flame Resistance</th></tr></thead>
            <tbody>
                <?php if (get_field('upholstery', $parentId)) { ?>
                    <tr><th>Upholstery:</th><td><?= get_field('upholstery', $parentId); ?></td></tr>
                <?php }  if (get_field('curtains', $parentId)) { ?>
                    <tr><th>Curtains:</th><td><?= get_field('curtains', $parentId); ?></td></tr>
                <?php }  if (get_field('bedding', $parentId)) { ?>
                    <tr><th>Bedding:</th><td><?= get_field('bedding', $parentId); ?></td></tr>
                <?php }  if (get_field('contract', $parentId)) { ?>
                    <tr><th>Contract:</th><td><?= get_field('contract', $parentId); ?></td></tr>
                <?php } if (get_field('fr_rating', $parentId)) { ?>
                    <tr><th>FR Rating:</th><td><?= get_field('fr_rating', $parentId); ?></td></tr>
                <?php } if (get_field('ce', $parentId)) { ?>
                    <tr><th>CE:</th><td><?= get_field('ce', $parentId); ?></td></tr>
                <?php } if (get_field('imo', $parentId)) { ?>
                    <tr><th>IMO:</th><td><?= get_field('imo', $parentId); ?></td></tr>
                <?php } ?>
                <tr><th>Colour Match:</th><td>Colour may vary from one batch to another.<br/>If an exact match is required, please ask for a stock cutting.</td></tr>
                <tr><th>Cleaning:</th><td>If spot cleaning is required please contact our sales office for general instructions.</td></tr>            
            </tbody>
        </table>
    </div>