<?php
namespace B2\Scruffy;

class PageMeta
{

    public function __construct()
    {
        add_action('wp_head', array($this, 'addCompanyMeta'));
        add_action('acf/init', function() {
            acf_update_setting('google_api_key', 'AIzaSyCR4T7FVkodpoKHETbPTYzUFvW9WakQPmA');
        });
    }

    public function addCompanyMeta()
    {
        $meta = array(
            '@context' => 'http://schema.org',
            '@type' => 'LocalBusiness',
            'url' => home_url()
        );

        if (get_field('company_name', 'option')) {
            $meta['name'] = get_field('company_name', 'option');
        }

        if (get_field('contact_phone_number', 'option')) {
            $meta['telephone'] = get_field('contact_phone_number', 'option');
        }

        if (get_field('contact_email_address', 'option')) {
            $meta['email'] = get_field('contact_email_address', 'option');
        }

        if (get_field('company_location', 'option')) {
            $location = get_field('company_location', 'option');
            $meta['address'] = $location['address'];
            
            $meta['geo'] = array(
                '@type' => 'GeoCoordinates',
                'latitude' => $location['lat'],
                'longitude' => $location['lng']
            );
        }

        if (get_field('company_logo', 'option')) {
            $logoObj = get_field('company_logo', 'option');
            $logoURL = substr($logoObj['url'], 0, 4) == 'http' ? $logoObj['url'] : home_url($logoObj['url']);
            $meta['logo'] = $logoURL;
        }

        if (have_rows('social_media_channels', 'option')) {
            $meta['sameAs'] = array();
            while (have_rows('social_media_channels', 'option')) { 
                the_row();
                $meta['sameAs'][] = get_sub_field('full_url');
            }
        }
                
        echo '<script type="application/ld+json">';
        echo json_encode($meta);
        echo '</script>';
    }
}