<?php 

$international = get_field('international_layout');

$searchString = filter_input(INPUT_POST, 'supplier_postcode', FILTER_SANITIZE_STRING);
?>

<div class="suppliers-row <?= $international ? 'international' : ''; ?>">

<?php 
if(!$international){    
    ?>
    <div class="col-md">
        <div id="map"></div>
    </div>

    <div class="col-md">
        <?php get_template_part( 'templates/parts/supplier-header'); ?>    

        <?php $locations = B2\SekersSite::supplierPostcodeForm();

            $coordList = [];
            if ($locations) {
                global $post;
                foreach ($locations as $post) {
                    setup_postdata($post);

                    $lat = get_field('b2_lat');
                    $lng = get_field('b2_lng');

                    if($lat && $lng){
                        $coordList[] = ['id' => get_the_ID(), 'lat' => $lat, 'lng' => $lng, 'title' => get_the_title(), 'info' => '<h3>'.get_the_title().'</h3>'.B2\SekersSite::getFullAddress(get_the_ID())];
                    }
                    
                    get_template_part( 'templates/parts/supplier');
                }
                wp_reset_postdata();
            };
            ?>
    </div>   
    <?php
    }
    else{
        ?>

    <div class="col-6 offset-3">
        <?php get_template_part( 'templates/parts/supplier-header');?>
    </div>
    <div class="col-12">
        <div id="map"></div>
    </div>
</div>

<div class="container">
    <div class="row suppliers-row <?= $international ? 'international' : ''; ?>">

<?php $locations = B2\SekersSite::supplierPostcodeForm();

    $coordList = [];
    if ($locations) {
        global $post;
        foreach ($locations as $post) {
            setup_postdata($post);

            $lat = get_field('b2_lat');
            $lng = get_field('b2_lng');

            if($lat && $lng){
                $coordList[] = ['id' => get_the_ID(), 'lat' => $lat, 'lng' => $lng, 'title' => get_the_title(), 'info' => '<h3>'.get_the_title().'</h3>'.B2\SekersSite::getFullAddress(get_the_ID())];
            }
            echo '<div class="col-6">';
            get_template_part( 'templates/parts/supplier');
            echo '</div>';
        }
        wp_reset_postdata();
    };
    ?>

    </div>
<?php
    }
   ?>
</div>


<script type="text/javascript">

    var markers = [];

    $(document).ready(function(){

        $('.supplier .marker a').click(function(){
            var id = $(this).data('id');
            google.maps.event.trigger(markers[id], 'click');
        });

    });

    function initMap() {
        
        var locations = <?php echo json_encode($coordList); ?>;
        var map = new google.maps.Map(document.getElementById('map'), {
            zoom: <?= $international ? 3 : 6; ?>,
            center: new google.maps.LatLng(54.7,-5.2137885),
            mapTypeId: google.maps.MapTypeId.ROADMAP,

        });

        var infowindow = new google.maps.InfoWindow();

        var marker, i;

        var latLngBounds = new google.maps.LatLngBounds();
        for (i = 0; i < locations.length; i++) {
            var myLatLng = new google.maps.LatLng(locations[i].lat, locations[i].lng);

            marker = new google.maps.Marker({
                position: myLatLng,
                map: map,
                title: locations[i].title
            });

            google.maps.event.addListener(marker, 'click', (function(marker, i) {
                return function() {
                    infowindow.setContent(locations[i].info);
                    infowindow.open(map, marker);
                }
            })(marker, i));
           latLngBounds.extend(myLatLng);

           markers[locations[i].id] = marker;
        }
        google.maps.event.addListenerOnce(map, 'bounds_changed', function (event) {
            if (this.getZoom() > 15) {
                this.setZoom(15);
            }
            if (this.getZoom() > 8) {
                this.setZoom(8);
            }
        });

        <?php if($searchString){
            echo "map.fitBounds(latLngBounds);";
        }?>
    }
</script>



<script async defer src="https://maps.googleapis.com/maps/api/js?key=<?php echo B2\SekersSite::GOOGLE_API_KEY; ?>&callback=initMap"></script>
