<?php

/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.0.0
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

get_header('shop'); ?>

<?php if (is_shop()) {
	get_template_part('templates/parts/collection', 'header');
	?>

<div class="container collections">
	<div class="product-container">
		<div class="col-12 col-md-4 col-xl-3">
			<p class="search-col-label">Search By:</p>
			<?php get_template_part('templates/parts/search', 'bar'); ?>
		</div>

		<div class="col-12 col-md-8 col-xl-9 collections-ctn">
			<div class="right-panel">
				<div class="row">
					<?php \B2\SekersSiteWooCustom::showFilteredCollections(); ?>
					<?php // \B2\SekersSiteWooCustom::showFilteredFroneCollections(); ?>
				</div>
			</div>
		</div>
	</div>
</div>
	<?php

} else {
	/**
	 * woocommerce_before_main_content hook.
	 *
	 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
	 * @hooked woocommerce_breadcrumb - 20
	 * @hooked WC_Structured_Data::generate_website_data() - 30
	 */
	do_action('woocommerce_before_main_content');
	?>
 <?php /*

    <header class="woocommerce-products-header">

		<?php if ( apply_filters( 'woocommerce_show_page_title', true ) ) : ?>

			<h1 class="woocommerce-products-header__title page-title"><?php woocommerce_page_title(); ?></h1>

		<?php endif; ?>

		<?php
			/**
 * woocommerce_archive_description hook.
 *
 * @hooked woocommerce_taxonomy_archive_description - 10
 * @hooked woocommerce_product_archive_description - 10
 *
			do_action( 'woocommerce_archive_description' );
		?>

    </header>

		<?php */

if (is_product_category()) {
	global $wp_query;
	$cat = $wp_query->get_queried_object();
	$internal_banner = the_field('internal_banner', $cat);

	if($internal_banner){
		$banner_id = 0;
	}
	else{
	$banner_id = get_woocommerce_term_meta($cat->term_id, 'thumbnail_id', true);
	}
	$image = wp_get_attachment_image($banner_id, 'sekers-banner--thin');
	?>
	<div class="pane-row pane-row--overlap pane-row--internal">
        <div class="flexslider flexslider-collection flexslider-collection--internal">
          <ul class="slides">
            <li>
            <?php echo $image; ?>

            </li>
          </ul>
        </div>
        <div class="pane pane--dark pane__content pane--internal pane--collection">

                    <div class="angle-me-container">
                       <div class="angle-me"> </div>
                   </div>
                  <div class='slide-info'>
        		  <h2><?php echo $cat->name; ?></h2>
				  <?php the_field('long_description', $cat); ?>

              </div>

            </div>
	</div>

<div class="container">
	<?php wc_print_notices(); ?>
	<div class="product-container collections-ctn">
		<div class="col-12 col-md-4 col-xl-3">
			<p class="search-col-label">Search By:</p>
			<?php get_template_part('templates/parts/search', 'bar'); ?>
		</div>
<?php
}
if (have_posts()) : ?>

			<?php
		/**
		 * woocommerce_before_shop_loop hook.
		 *
		 * @hooked wc_print_notices - 10
		 * @hooked woocommerce_result_count - 20
		 * @hooked woocommerce_catalog_ordering - 30
		 */
		//do_action( 'woocommerce_before_shop_loop' );
		?>

			<?php //woocommerce_product_loop_start(); ?>

<div class="col-12 col-md-8 col-xl-9">
	<div class="right-panel">
		<div class="row">

			<?php

		$variations = [];

		while (have_posts()) : the_post();

		$parentId = wp_get_post_parent_id(get_the_ID());

		$parent = get_post($parentId);

		$product_cats = wp_get_post_terms( get_the_ID(), 'product_cat' );

		if(!isset($variations[$parent->post_name])){
			$variations[$parent->post_name] = ['parentId' => $parentId, 'html' => '', 'title' => $parent->post_title];
		}

			ob_start();
			/**
			 * woocommerce_shop_loop hook.
			 *
			 * @hooked WC_Structured_Data::generate_product_data() - 10
			 */
			do_action('woocommerce_shop_loop');
			wc_get_template_part('content', 'product');
			$variation_panel = ob_get_clean();

			$variations[$parent->post_name]['html'] .= $variation_panel;

		endwhile; // end of the loop.?>
		<div class="col-12" id="accordion">
			<?php
			$first = true;
			foreach($variations as $slug => $variationInfo){

				if(isset($_GET['pid']) && $_GET['pid'] == $variationInfo['parentId']){
					$first = true;
				}
				?>
						<div class="card">
                            <div class="card-header" id="heading<?php echo $slug; ?>">
                                <h5 class="mb-0">
                                    <button class="btn btn-link w-100" data-toggle="collapse" data-target="#collapse<?php echo $slug; ?>" aria-expanded="true" aria-controls="collapse<?php echo $slug; ?>">
                                        <?php echo '<h3>'.$variationInfo['title'].'</h3>'; ?>
                                        <span class="plus"><i class="fa fa-plus"></i></span>
                                        <span class="minus"><i class="fa fa-minus"></i></span>
                                    </button>
                                </h5>
                            </div>

                            <div id="collapse<?php echo $slug; ?>" class="collapse show" aria-labelledby="heading<?php echo $slug; ?>">
                                <div class="card-body variation-row">
									<?= $variationInfo['html']; ?>
                                </div>
                            </div>
                        </div>
						<?php
						$first = false;
			}
			?>
		</div>

			</div>
		</div>
	</div>
</div>
		</div>
		<?php //woocommerce_product_loop_end(); ?>

		<?php

	/**
	 * woocommerce_after_shop_loop hook.
	 *
	 * @hooked woocommerce_pagination - 10
	 */
	do_action('woocommerce_after_shop_loop');
		//}


	?>

		<?php elseif (!woocommerce_product_subcategories(array('before' => woocommerce_product_loop_start(false), 'after' => woocommerce_product_loop_end(false)))) : ?>

			<?php

		/**
		 * woocommerce_no_products_found hook.
		 *
		 * @hooked wc_no_products_found - 10
		 */
		do_action('woocommerce_no_products_found');
		?>

		<?php endif; ?>
</div>
</div>
	<?php

}
/**
 * woocommerce_after_main_content hook.
 *
 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
 */
do_action('woocommerce_after_main_content');
?>

	<?php

/**
 * woocommerce_sidebar hook.
 *
 * @hooked woocommerce_get_sidebar - 10
 */
		//do_action( 'woocommerce_sidebar' );
?>

<?php get_footer('shop'); ?>
